/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import pcgen.core.Globals;
import pcgen.util.Logging;

public final class PropertyFactory {
    private static Properties properties;
    public static final String UNDEFINED = " not defined.";

    public static char getMnemonic(String property) {
        return PropertyFactory.getMnemonic(property, '\u0000');
    }

    public static String getString(String key) {
        return PropertyFactory.getProperty(key);
    }

    public static String getFormattedString(String key, Object arg0) {
        String prop = PropertyFactory.getString(key);
        Object[] args = new Object[]{arg0};
        return MessageFormat.format(prop, args);
    }

    public static String getFormattedString(String key, Object arg0, Object arg1) {
        String prop = PropertyFactory.getString(key);
        Object[] args = new Object[]{arg0, arg1};
        return MessageFormat.format(prop, args);
    }

    public static String getFormattedString(String key, Object arg0, Object arg1, Object arg2) {
        String prop = PropertyFactory.getString(key);
        Object[] args = new Object[]{arg0, arg1, arg2};
        return MessageFormat.format(prop, args);
    }

    public static String getFormattedString(String key, Object[] args) {
        String prop = PropertyFactory.getString(key);
        return MessageFormat.format(prop, args);
    }

    private static char getMnemonic(String property, char def) {
        String mnemonic = PropertyFactory.getProperty(property);
        if (mnemonic.length() != 0) {
            return mnemonic.charAt(0);
        }
        return def;
    }

    private static String getProperty(String key) {
        String value = properties.getProperty(key);
        if (value == null) {
            value = key + UNDEFINED;
            properties.setProperty(key, value);
        }
        return value;
    }

    private static void init() {
        properties = new Properties();
        Locale currentLocale = new Locale(Globals.getLanguage(), Globals.getCountry());
        ResourceBundle[] bundles = new ResourceBundle[1];
        try {
            bundles[0] = ResourceBundle.getBundle("pcgen/gui/prop/LanguageBundle", currentLocale);
        }
        catch (MissingResourceException mrex) {
            bundles[0] = null;
            Logging.errorPrint("Can't find language bundle", mrex);
        }
        for (int i = 0; i < bundles.length; ++i) {
            if (bundles[i] == null) continue;
            Enumeration<String> keys = bundles[i].getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                properties.setProperty(key, bundles[i].getString(key));
            }
        }
    }

    static {
        PropertyFactory.init();
    }
}

