/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Add
extends PostfixMathCommand {
    public Add() {
        this.numberOfParameters = -1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object object = stack.pop();
        int n = 1;
        while (n < this.curNumberOfParameters) {
            Object e = stack.pop();
            object = this.add(e, object);
            ++n;
        }
        stack.push(object);
    }

    public Object add(Object object, Object object2) throws ParseException {
        if (object instanceof Number) {
            if (object2 instanceof Number) {
                return this.add((Number)object, (Number)object2);
            }
            if (object2 instanceof Complex) {
                return this.add((Complex)object2, (Number)object);
            }
        } else if (object instanceof Complex) {
            if (object2 instanceof Number) {
                return this.add((Complex)object, (Number)object2);
            }
            if (object2 instanceof Complex) {
                return this.add((Complex)object, (Complex)object2);
            }
        } else if (object instanceof String && object2 instanceof String) {
            return (String)object + (String)object2;
        }
        throw new ParseException("Invalid parameter type");
    }

    public Double add(Number number, Number number2) {
        return new Double(number.doubleValue() + number2.doubleValue());
    }

    public Complex add(Complex complex, Complex complex2) {
        return new Complex(complex.re() + complex2.re(), complex.im() + complex2.im());
    }

    public Complex add(Complex complex, Number number) {
        return new Complex(complex.re() + number.doubleValue(), complex.im());
    }
}

