# Copyright (c) 2001  Peter Pentchev
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

# $Ringlet: c/misc/penv/Makefile.inc,v 1.27 2004/01/27 15:08:03 roam Exp $

PROG=		penv

SRCS=		penv.c pe_cmd.c pe_compat.c pe_env.c pe_err.c pe_log.c pe_var.c
CLEANFILES+=	penv.conf.default ${PROG}.1

VERPFX=		PE
PE_VER_MAJ	=1
PE_VER_MIN	=2
PE_VER_PRE	=0
PE_VER_PATCH	=1

PREFIX?=	/usr/local
BINDIR=		${PREFIX}/bin
MANDIR=		${PREFIX}/man/man
ETCDIR?=	${PREFIX}/etc
DBDIR?=		/var/db/${PROG}

CC?=		gcc
WARNS?=		2
CFLAGS_WARN=	-Wall -W -Wstrict-prototypes -Wmissing-prototypes \
		-Wwrite-strings #${BDECFLAGS}
CFLAGS_INC=	-I. -I..
# CFLAGS_OPT and CFLAGS_DBG must be defined in OS-dependent Makefiles
CFLAGS_MISC=	-D_GNU_SOURCE

CFLAGS_VER=	-DPE_VER_MAJ=${PE_VER_MAJ} \
		-DPE_VER_MIN=${PE_VER_MIN} \
		-DPE_VER_PRE=${PE_VER_PRE} \
		-DPE_VER_PATCH=${PE_VER_PATCH} \
		-DPE_OS=\"${CFLAGS_OS_VER}\" \
		-DPE_OSREL=\"${CFLAGS_OS_REL}\" \
		-DPE_OSHOST=\"${CFLAGS_OS_HOST}\" \
		-DPE_PREFIX=\"${PREFIX}\" \
		-DPE_ETCDIR=\"${ETCDIR}\" \
		-DPE_DBDIR=\"${DBDIR}\" \
		-DPE_ENVDIR=\"${WITH_ENVDIR}\"

CFLAGS=		${CFLAGS_WARN} ${CFLAGS_OPT} ${CFLAGS_DBG} ${CFLAGS_COMPAT}
CFLAGS+=	${CFLAGS_INC} ${CFLAGS_OS} ${CFLAGS_VER} ${CFLAGS_MISC}

LDADD=
DPADD=

RM?=		rm -f
MKDIR?=		mkdir -p
SETENV?=	env
COMPRESS_CMD?=	gzip -cn
SED?=		sed

# GNU make hack
.CURDIR?=	.

all:		${PROG} penv.conf.default

penv.conf.default:	penv.conf.default.in
		${SED} -e "s!%%ENVDIR%%!${WITH_ENVDIR}!" \
		    -e "s!%%DBDIR%%!${DBDIR}!" \
		    -e "s!%%ETCDIR%%!${ETCDIR}!" \
		    ${.CURDIR}/penv.conf.default.in > penv.conf.default

${PROG}.1:	${PROG}.in.1
		${SED} -e "s!%%ENVDIR%%!${WITH_ENVDIR}!" \
		    -e "s!%%DBDIR%%!${DBDIR}!" \
		    -e "s!%%ETCDIR%%!${ETCDIR}!" \
		    ${.CURDIR}/penv.in.1 > penv.1
