<?xml version="1.0" encoding="ISO-8859-1" ?>

<!-- $Ringlet: c/misc/penv/doc/en_US.ISO8859-1/xml/changes/changes.xsl,v 1.3 2002/03/21 10:57:25 roam Exp $ -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:cvs="http://www.ringlet.net/XML/CVS">

  <xsl:import href="../includes.xsl"/>
  <xsl:import href="includes.xsl"/>


  <xsl:variable name="base" select="'..'"/>
  <xsl:variable name="title" select="'penv Change Log'"/>
  <xsl:variable name="date">
    <xsl:value-of select="//cvs:keyword[@name='ringlet']"/>
  </xsl:variable>
  
  <xsl:output type="html" encoding="iso-8859-1"/>

  <xsl:template match="news">
    <html>
      
      <xsl:copy-of select="$header1"/>

      <body xsl:use-attribute-sets="att.body">

	<xsl:copy-of select="$header2"/>

	<p>This is a list of the changes made to the penv program
	  over time.  If things do not look quite right, please
	  complain to the author <a href="mailto:roam@ringlet.net">
	  Peter Pentchev &lt;roam@ringlet.net&gt;</a> :)</p>
	
	<xsl:apply-templates select="descendant::contrib"/>

	<xsl:apply-templates select="descendant::release"/>
	
	<xsl:copy-of select="$footer"/>
      </body>
    </html>
  </xsl:template>

  <!-- Everything that follows are templates for the rest of the content -->
  
  <xsl:template match="release">
    <h2><xsl:value-of select="name"/>
      <xsl:text> - </xsl:text>
      <xsl:value-of select="reldate"/></h2>
      
    <ul>
      <xsl:apply-templates select="descendant::month"/>
    </ul>
  </xsl:template>

  <xsl:template match="month">
    <xsl:apply-templates select="descendant::day"/>
  </xsl:template>

  <xsl:template match="day">
    <xsl:apply-templates select="event"/>
  </xsl:template>

  <xsl:template match="event">
    <li><p><a>
	  <xsl:attribute name="name">
	    <xsl:call-template name="generate-event-anchor"/>
	  </xsl:attribute>
	</a>

	<b><xsl:value-of select="ancestor::day/name"/>
	  <xsl:text> </xsl:text>
	  <xsl:value-of select="ancestor::month/name"/>, 
	  <xsl:value-of select="ancestor::year/name"/>:</b>
	  <xsl:text> [</xsl:text>
	  <a>
	    <xsl:attribute name="href">#contrib-<xsl:value-of select="who"/>
	    </xsl:attribute>
	    <xsl:value-of select="who"/>
	  </a>
	  <xsl:text>] </xsl:text>
	<xsl:apply-templates select="p"/>
	</p>

    </li>
  </xsl:template>

  <xsl:template match="date"/>    <!-- Deliberately left blank -->

  <!-- When the href attribute contains a '$base', expand it to the current
       value of the $base variable. -->

  <!-- All your $base are belong to us.  Ho ho ho -->
  <xsl:template match="a">
    <a><xsl:attribute name="href">
	<xsl:choose>
	  <xsl:when test="contains(@href, '$base')">
	    <xsl:value-of select="concat(substring-before(@href, '$base'), $base, substring-after(@href, '$base'))"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:value-of select="@href"/>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:attribute>
      <xsl:apply-templates/>
    </a>
  </xsl:template>

  <xsl:template match="contrib">
    <a>
      <xsl:attribute name="name">contrib</xsl:attribute>
    </a>

    <h2>Authors/contributors:</h2>

    <ul>
      <xsl:apply-templates select="descendant::author"/>

      <xsl:apply-templates select="descendant::contributor"/>
    </ul>
  </xsl:template>

  <xsl:template match="author">
    <li><p>
      <a>
	<xsl:attribute name="name">contrib-<xsl:value-of select="uname"/>
	</xsl:attribute>
      </a>
      <a>
	<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>
	</xsl:attribute>
	<xsl:value-of select="name"/>
	<xsl:text> &lt;</xsl:text>
	<xsl:value-of select="email"/>
	<xsl:text>&gt;</xsl:text>
      </a>
    </p></li>
  </xsl:template>

  <xsl:template match="contributor">
    <li><p>
      <a>
	<xsl:attribute name="name">contrib-<xsl:value-of select="uname"/>
	</xsl:attribute>
      </a>
      <a>
	<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>
	</xsl:attribute>
	<xsl:value-of select="name"/>
	<xsl:text> &lt;</xsl:text>
	<xsl:value-of select="email"/>
	<xsl:text>&gt;</xsl:text>
      </a>
    </p></li>
  </xsl:template>
</xsl:stylesheet>
