/*-
 *  Copyright (c) 2001  Peter Pentchev
 *  All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 * 
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 */

#include <sys/types.h>

#include <stdio.h>
#include <string.h>

#include "penv.h"
#include "pe_cmd.h"
#include "pe_env.h"

__RINGID("$Ringlet: c/misc/penv/pe_cmd.c,v 1.6 2004/01/06 16:38:10 roam Exp $");

static pe_err_t	pe_c_help(int argc, char *argv[]);

static struct pe_cmd	cmds[] = {
	{"exec",	'\0',	pe_c_exec,	"execute a program"},
	{"help",	'\0',	pe_c_help,	"display this help message"},
	{"list",	'L',	pe_c_envlist,	"list the envdir contents"},
	{"mkdir",	'\0',	pe_c_mkdir,	"create the envdir"},
	{"path",	'p',	pe_c_printpath,	"display the envdir path"},
	{"reset",	'R',	pe_c_resetvar,	"unset a envdir variable"},
	{"set",		'S',	pe_c_setvar,	"set a envdir variable"},
	{NULL,		'\0',	NULL,		NULL}
};
static struct pe_cmd	*chosencmd;

static pe_err_t
pe_c_help(int argc, char *argv[] __unused) {
	unsigned i;
	
	if (argc > 0)
		usage();

	if (!quiet)
		printf("Available penv actions:\n");
	for (i = 0; cmds[i].name != NULL; i++) {
		printf("%s", cmds[i].name);
		if (quiet < 2)
			printf("\t%s", cmds[i].desc? cmds[i].desc: "");
		printf("\n");
	}
	return (PE_ERR_NONE);
}

pe_err_t
pe_cmd_set(const char *name, char sname) {
	unsigned i;

	for (i = 0; cmds[i].name != NULL; i++) {
		if ((name != NULL) && !strcasecmp(name, cmds[i].name))
			break;
		if ((sname != '\0') && (sname == cmds[i].sname))
			break;
	}
	if (cmds[i].name == NULL)
		return (PE_ERR_NOCMD);

	if ((chosencmd != NULL) && (chosencmd != cmds + i))
		return (PE_ERR_CONFCMD);
	chosencmd = cmds + i;
	return (PE_ERR_NONE);
}

pe_err_t
pe_cmd_exec(int argc, char *argv[]) {
	pe_err_t r;

	if (chosencmd == NULL)
		if (r = pe_cmd_set("exec", '\0'), r)
			return (r);
	if (chosencmd->fun == NULL)
		return (PE_ERR_INT);
	return (chosencmd->fun(argc, argv));
}
