#ifndef _INCLUDED_PE_VAR_H
#define _INCLUDED_PE_VAR_H

/*-
 *  Copyright (c) 2001  Peter Pentchev
 *  All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 * 
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *
 *  $Ringlet: c/misc/penv/pe_var.h,v 1.5 2001/10/26 16:06:44 roam Exp $
 */

/* * *		Definitions		* * */

typedef enum {
	PE_VT_NULL,
	PE_VT_STRING, PE_VT_INT, PE_VT_UINT,
	PE_VT_LAST
} pe_vartype;

struct pe_var {
	const char	*name;
	pe_vartype	 type;
	size_t		 size;
	void		*val;
	int		 set;
};

/* * *		Variables		* * */


/* * *		Functions		* * */

pe_err_t	pe_var_readfile(struct pe_var *vars, const char *fname,
		int required);
pe_err_t	pe_var_parseline(struct pe_var *vars, const char *line,
		size_t sz);
pe_err_t	pe_var_set(struct pe_var *vars,
		const char *name, const char *val);

#endif /* _INCLUDED */
