#ifndef __INCLUDED_penv_h
#define __INCLUDED_penv_h

/*-
 *  Copyright (c) 2001  Peter Pentchev
 *  All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 * 
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *
 *  $Ringlet: c/misc/penv/penv.h,v 1.17 2004/01/06 16:38:10 roam Exp $
 */

#ifndef __unused
#ifdef __GNUC__
#define __unused	__attribute__((unused))
#else
#define __unused
#endif /* __GNUC__ */
#endif /* __unused */

#ifndef RDBG
#ifdef EBUG
#define RDBG(x)         if (quiet < 2) { printf x; }
#else /* !EBUG */
#define RDBG(x)
#endif /* EBUG */
#endif /* RDBG */

#ifndef RINF
#define RINF(x)         printf x;
#endif /* RINF */

/* __IDSTRING() and __RCSID() are borrowed from FreeBSD's <sys/cdefs.h> */
#ifndef __IDSTRING
#if defined(__GNUC__) && defined(__ELF__)
#define	__IDSTRING(name,string)	__asm__(".ident\t\"" string "\"")
#else  /* __GNUC__ && __ELF__ */
#define	__IDSTRING(name,string)	static const char name[] __unused = string
#endif /* __GNUC__ && __ELF__ */
#endif /* IDSTRING */

#ifndef __RCSID
#define	__RCSID(s)	__IDSTRING(rcsid,s)
#endif /* __RCSID */

/* __RINGID() is modelled after FreeBSD's __FBSDID() */
#ifndef	__RINGID
#ifdef __FBSDID
#define __RINGID(s)	__FBSDID(s)
#else  /* __FBSDID */
#if !defined(lint) && !defined(STRIP_RINGID)
#define	__RINGID(s)	__IDSTRING(__CONCAT(__rcsid_,__LINE__),s)
#else
#define	__RINGID(s)	struct __hack
#endif
#endif /* __FBSDID */
#endif

/* * *		Definitions		* * */

typedef enum {
	PE_ERR_NONE,
	PE_ERR_NOMEM, PE_ERR_CMDLINE,
	PE_ERR_GETCWD, PE_ERR_BASENAME, PE_ERR_DIRNAME,
	PE_ERR_FSTAT, PE_ERR_EXEC,
	PE_ERR_CFG_OPEN, PE_ERR_CFG_READ,
	PE_ERR_CFG_SYNTAX, PE_ERR_CFG_NXVAR,
	PE_ERR_CFG_BADVAL, PE_ERR_CFG_STRLONG,
	PE_ERR_NOCMD, PE_ERR_CONFCMD,
	PE_ERR_MKDIR, PE_ERR_CHDIR, PE_ERR_UNLINK, PE_ERR_OPENDIR,
	PE_ERR_VAR_FMT,
	PE_ERR_FOPEN, PE_ERR_FCHMOD,
	PE_ERR_INT,
	PE_ERR_LAST
} pe_err_t;

#define PE_OPTSTR	"c:CD:d:f:hLm:no:pqRSVv"

#define PE_DEPTH	2

#ifndef PE_ENVDIR
#define PE_ENVDIR	"envdir"
#endif

#define PE_FILEMODE	"644"

/* * *		Variables		* * */

extern unsigned	verbose, quiet;
extern char	pe_verstr[];

extern char	*pe_cenvdir;

extern mode_t	pe_filemode;

/* * *		Functions		* * */

void		usage(void);

pe_err_t	pe_c_exec(int argc, char *argv[]);
pe_err_t	pe_c_mkdir(int argc, char *argv[]);
pe_err_t	pe_c_printpath(int argc, char *argv[]);

#endif /* __INCLUDED_penv_h */
