/* PIPClient - A client for finger protocol v2
 *
 * Copyright (C) 1999 Michael Baumer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif /* HAVE_STRINGS_H */

#include "configfile.h"
#include "parser.h"

#if (GTK_MAJOR_VERSION == 1) && (GTK_MINOR_VERSION == 0)
#define gtk_window_set_position gtk_window_position
#define gtk_container_set_border_width gtk_container_border_width
#endif

void NewUserinfo();

typedef struct newuserinfo_data {
  GtkEntry *first;
  GtkEntry *last;
  GtkEntry *nick;
  GtkEntry *email;
  GtkEntry *homepage;
  GtkTree *tree;
} newuserinfo_data;

void make_subtree(Node *current, GtkWidget *parent);

extern Node *cf;
extern char *configfile;
/* global vars that should not be global vars... */
Node *oldnode;

gint delete_userinfo( GtkWidget *widget,
		      GdkEvent  *event,
		      gpointer   data )
{
  /*  writeFingerconf(configfile, cf); */

  /* Destroy main window */  
  return(FALSE);
}

void close_cb(gpointer data, gpointer window)
{
  gtk_widget_destroy(window);
}

void userinfo_save_cb(gpointer data, gpointer tree)
{
  char *txt;
  GtkWidget *text;
  int len;
  GtkTree *root_tree;

  if (oldnode) {
    root_tree = GTK_TREE_ROOT_TREE(tree);
    text = gtk_object_get_data(GTK_OBJECT(root_tree), "text");
    len = gtk_text_get_length( GTK_TEXT(text) );
    if (len < oldnode->val_len) {
      txt = gtk_editable_get_chars(GTK_EDITABLE(text), 0, -1);
      strcpy (oldnode->value, txt);
      free(txt);
    }
  }

  writeFingerconf(configfile, cf);
}

gint addentry_cb(GtkWidget *button, gpointer data)
{
  GtkWidget *key;
  GtkWidget *content;
  Node *curr;
  Node *current;
  char *key_txt;
  char *cont_txt;
  GtkWidget *tree;
  GtkWidget *top;

  key = gtk_object_get_data(GTK_OBJECT(button), "key");
  content = gtk_object_get_data(GTK_OBJECT(button), "content");
  tree = gtk_object_get_data(GTK_OBJECT(button), "tree");

  key_txt = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(key)->entry));
  cont_txt = gtk_editable_get_chars(GTK_EDITABLE(content), 0, -1);
  
  /* make a node and initialize it */
  if (!cf) {
    /* until now we have no configfile
     * therefore create one
     */
    cf = newNode(0);
    strcpy(cf->id, "fingerconf");
    cf->child = newNode(0);
    cf->last = cf->child;
    curr = cf->child;
    curr->parent = cf;
    oldnode = curr;
    strcpy(curr->id, "userinfo");
    curr->child = newNode(strlen(cont_txt)+1);
    curr->last = curr->child;
    curr->child->parent = curr;
    curr = curr->child;
  }
  else {
    /* search for insertion point by looking at oldnode */
    curr = oldnode;
    if (curr->child) 
      /* descend only one level */
      curr = curr->child;
    while(curr->next)
      curr = curr->next;
    curr->next = newNode(strlen(cont_txt)+1);
    curr->next->parent = curr->parent;
    curr->parent->last = curr->next;
    curr = curr->next;
  }

  /* now we fill in the node */
  strncpy(curr->id, key_txt, MAX_ID_LEN-1);
  strcpy(curr->value, cont_txt);

  /* recreate the tree */
  gtk_tree_clear_items(GTK_TREE(tree), 0, 1);
  top = gtk_tree_item_new_with_label("Userinfo");
  gtk_widget_show(top);
  gtk_tree_append(GTK_TREE(tree), top);
  current = cf->child;
  while (current) {
    if (!strcmp(current->id, "userinfo"))
      make_subtree(current->child, top);
    current = current->next;
  }
  GTK_TREE_SELECTION (tree) = NULL;  

  /*cleanup */
  free(cont_txt);

  return FALSE;
}

void add_entry(gpointer data, gpointer tree)
{
  GtkWidget *dialog;
  GtkWidget *content_text;
  GtkWidget *label;
  GtkWidget *vbox;
  GtkWidget *button;
  GtkWidget *combo;
  GList *defaults=NULL;

  /* Init the dialog window */
  
  dialog = gtk_window_new( GTK_WINDOW_DIALOG );
  gtk_window_set_title(GTK_WINDOW( dialog ), "Add Userinfo Entry");

  /* set initial position */
  gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
  
  /* papa box */
  vbox = gtk_vbox_new( FALSE, 0 );
  gtk_container_add( GTK_CONTAINER( dialog ), vbox );
  gtk_widget_show( vbox );
  
  /* Label for key */
  label = gtk_label_new( "Entry name:" );
  gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 5 );
  gtk_misc_set_alignment( GTK_MISC( label ), 0.5, 1 );
  gtk_widget_show( label );       

  /* set up some default key's */
  defaults = g_list_append(defaults, "first");
  defaults = g_list_append(defaults, "last");
  defaults = g_list_append(defaults, "email");
  defaults = g_list_append(defaults, "homepage");
  defaults = g_list_append(defaults, "address");
  defaults = g_list_append(defaults, "phone");
  defaults = g_list_append(defaults, "fax");

  /* the combo for entering the keys */
  combo = gtk_combo_new();
  gtk_combo_set_popdown_strings( GTK_COMBO(combo), defaults) ;
  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry), "");
  gtk_box_pack_start( GTK_BOX( vbox ), combo, FALSE, FALSE, 5 );
  gtk_widget_show( combo ); 
  gtk_widget_grab_focus( GTK_COMBO(combo)->entry );
  
  /* label for content */
  label = gtk_label_new( "Entry text:" );
  gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 5 );
  gtk_misc_set_alignment( GTK_MISC( label ), 0.5, 1 );
  gtk_widget_show( label );       

  /* initial text for this entry */
  content_text = gtk_text_new( NULL, NULL );
  gtk_box_pack_start( GTK_BOX( vbox ), content_text, FALSE, FALSE, 5 );
  gtk_widget_show( content_text );       
  gtk_text_set_editable(GTK_TEXT(content_text), TRUE);
    
  button = gtk_button_new_with_label( "OK" );
  gtk_object_set_data( GTK_OBJECT( button ), "key", combo );
  gtk_object_set_data( GTK_OBJECT( button ), "content", content_text );
  /* add tree info */
  gtk_object_set_data( GTK_OBJECT( button ), "tree", tree );

  gtk_signal_connect( GTK_OBJECT( button ), "clicked", 
		      GTK_SIGNAL_FUNC( addentry_cb ), 
		      NULL ); 
  gtk_signal_connect_object( GTK_OBJECT( button ), "clicked", 
			     GTK_SIGNAL_FUNC( gtk_widget_destroy ), 
			     GTK_OBJECT( dialog ) ); 
  gtk_widget_set_usize( button, 100, 30 );
  gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 5 );
  gtk_widget_show( button );

  button = gtk_button_new_with_label( "Cancel" );
  gtk_signal_connect_object( GTK_OBJECT( button ), "clicked", 
			     GTK_SIGNAL_FUNC( gtk_widget_destroy ), 
			     GTK_OBJECT( dialog ) ); 
  gtk_widget_set_usize( button, 100, 30 );
  gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 5 );
  gtk_widget_show( button );

  gtk_widget_show( dialog );
}

void item_selected( GtkTree *tree, GtkWidget *child )
{
  Node *node;
  int len;
  char *txt;
  GtkTree *root_tree;
  GtkWidget *text;

  root_tree = GTK_TREE_ROOT_TREE(tree);
  text = gtk_object_get_data(GTK_OBJECT(root_tree), "text");

  node = gtk_object_get_user_data(GTK_OBJECT(child));

  gtk_text_freeze( GTK_TEXT(text) );
  len = gtk_text_get_length( GTK_TEXT(text) );
  if (oldnode && (len < oldnode->val_len)) {
    txt = gtk_editable_get_chars(GTK_EDITABLE(text), 0, -1);
    strcpy (oldnode->value, txt);
    free(txt);
  }
  gtk_text_set_point(GTK_TEXT(text), 0);
  gtk_text_forward_delete(GTK_TEXT(text), len);

  gtk_text_insert( GTK_TEXT(text), NULL, NULL, NULL, node->value, -1);

  gtk_text_thaw( GTK_TEXT(text) );         

  oldnode = node;
}

#if (GTK_MAJOR_VERSION == 1) && (GTK_MINOR_VERSION == 0)

GtkWidget *create_userinfo_menu(GtkWidget *window, GtkWidget *tree)
{
  GtkMenuEntry menu_items[] = {
    { "<userinfo>/File",         NULL,         NULL, 0 },
    { "<userinfo>/File/New",     "<control>N", NewUserinfo,
      GPOINTER_TO_UINT(tree) },
    { "<userinfo>/File/Save",     "<control>S", userinfo_save_cb, 
      GPOINTER_TO_UINT(tree) },
    { "<userinfo>/File/<separator>",     NULL,         NULL, 0  },
    { "<userinfo>/File/Close",     "<control>W", close_cb, 
      GPOINTER_TO_UINT(window) },
    { "<userinfo>/Userinfo",      NULL,         NULL, 0 },
    { "<userinfo>/Userinfo/Add Entry",  "<control>A", add_entry,  
      GPOINTER_TO_UINT(tree) },
    { "<userinfo>/Help",         NULL,         NULL, 0 },
    { "<userinfo>/Help/About",   NULL,         NULL, 0 },   
  };    
  GtkMenuFactory *factory;
  GtkMenuFactory *subfactory;
  int nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);

  factory = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
  subfactory = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
  
  gtk_menu_factory_add_subfactory(factory, subfactory, "<userinfo>");
  gtk_menu_factory_add_entries(factory, menu_items, nmenu_items);
  gtk_window_add_accelerator_table(GTK_WINDOW(window), subfactory->table);

  return(subfactory->widget);
}

#else

GtkWidget *create_userinfo_menu(GtkWidget *window, GtkWidget *tree)
{
  GtkItemFactoryEntry menu_items[] = {
    { "/_File",         NULL,         NULL, 0, "<Branch>" },
    { "/File/_New",     "<control>N", NewUserinfo,
      GPOINTER_TO_UINT(tree), NULL },
    { "/File/_Save",     "<control>S", userinfo_save_cb, 
      GPOINTER_TO_UINT(tree), NULL },
    { "/File/sep1",     NULL,         NULL, 0, "<Separator>" },
    { "/File/_Close",     "<control>W", close_cb, 
      GPOINTER_TO_UINT(window), NULL },
    { "/_Userinfo",      NULL,         NULL, 0, "<Branch>" },
    { "/Userinfo/_Add Entry",  "<control>A", add_entry,  
      GPOINTER_TO_UINT(tree), NULL },
    { "/_Help",         NULL,         NULL, 0, "<LastBranch>" },
    { "/_Help/_About",   NULL,         NULL, 0, NULL },
  };    
  gint nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);
  GtkAccelGroup *accel_group;
  GtkItemFactory *item_factory;

  accel_group = gtk_accel_group_new ();

  item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<userinfo>", 
				       accel_group);
  gtk_item_factory_create_items (item_factory, nmenu_items, menu_items, NULL);
  gtk_accel_group_attach (accel_group, GTK_OBJECT (window));

  return gtk_item_factory_get_widget (item_factory, "<userinfo>");

}

#endif /* GTK_MAJOR_VERSION == 1  && GTK_MINOR_VERSION == 0 */

/* Utility function for creating the userinfo tree
 *
 * This is be done recursively because we don't have a
 * GTK_TREE()->parent...
 */
void make_subtree(Node *current, GtkWidget *parent)
{
  GtkWidget *item;
  GtkWidget *subtree;

  subtree = gtk_tree_new();
  gtk_tree_item_set_subtree(GTK_TREE_ITEM(parent), subtree);
  gtk_tree_item_expand(GTK_TREE_ITEM(parent));
  gtk_signal_connect( GTK_OBJECT( subtree ), "select_child", 
		      GTK_SIGNAL_FUNC( item_selected ), 
		      NULL ); 

  while (current) {
    item = gtk_tree_item_new_with_label(current->id);
    gtk_object_set_user_data(GTK_OBJECT(item), current);
    gtk_widget_show(item);
    gtk_tree_append(GTK_TREE(subtree), item);
    if (current->child) 
      make_subtree(current->child, item);
     
    current = current->next;
  }
}

void ChangeUserinfo()
{
  GtkWidget *dialog;
  GtkWidget *hpane;
  GtkWidget *vbox1;
  GtkWidget *tree1;
  GtkWidget *scrolled_window1;
  GtkWidget *top;
  GtkWidget *menubar;
  GtkWidget *text;
  Node *current;

  /* Init the dialog window */
  
  dialog = gtk_window_new( GTK_WINDOW_DIALOG );
  gtk_window_set_title(GTK_WINDOW( dialog ), "Change Userinfo");

  /* set initial position */
  gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
  gtk_widget_set_usize( dialog, 450, 300 );

  /* on delete */
  gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
		      GTK_SIGNAL_FUNC (delete_userinfo), NULL);

  /* create the box */
  vbox1 = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox1);
  gtk_container_add(GTK_CONTAINER(dialog), vbox1);

  /* this is here for using it in the menu */
  tree1 = gtk_tree_new();

  /* create the menu */
  menubar = create_userinfo_menu(dialog, tree1);
  gtk_box_pack_start (GTK_BOX (vbox1), menubar, FALSE, FALSE, 0);
  gtk_widget_show (menubar);

  hpane = gtk_hpaned_new();
  gtk_widget_show(hpane);
  gtk_box_pack_start(GTK_BOX(vbox1), hpane, TRUE, TRUE, 0);

  scrolled_window1 = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(scrolled_window1);
  gtk_paned_add1(GTK_PANED(hpane), scrolled_window1);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window1),
                                 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(scrolled_window1, 160, -1);

  gtk_widget_show(tree1);
  
#if (GTK_MAJOR_VERSION == 1) && (GTK_MINOR_VERSION == 0)
  gtk_container_add (GTK_CONTAINER(scrolled_window1), tree1);
#else
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_window1),
					tree1);
#endif
  /* set various parameters */
  gtk_tree_set_selection_mode(GTK_TREE(tree1), GTK_SELECTION_SINGLE);
  gtk_tree_set_view_lines(GTK_TREE(tree1), 1);
  gtk_tree_set_view_mode(GTK_TREE(tree1), 0);
  gtk_widget_show(tree1);

  text = gtk_text_new(NULL, NULL);
  gtk_widget_show(text);
  gtk_paned_add2(GTK_PANED(hpane), text);
  gtk_text_set_editable(GTK_TEXT(text), TRUE);

  top = gtk_tree_item_new_with_label("Userinfo");
  gtk_widget_show(top);
  gtk_tree_append(GTK_TREE(tree1), top);
  gtk_object_set_data(GTK_OBJECT(tree1), "text", text);

  /* Make the subtree from the configfile */
  if ((current = cf)) {
    current = current->child;
    oldnode  = current;
    while (current) {
      if (!strcmp(current->id, "userinfo"))
	make_subtree(current->child, top);
      current = current->next;
    }
  }
  else
    oldnode = NULL;

  gtk_widget_show(dialog);
}

Node * addentry2node(GtkEntry *entry, Node *curr, char *id)
{
  char *txt;

  txt = gtk_entry_get_text(entry);
  if (strlen(txt)) {
    if (strlen(curr->id)) {
      curr->next = newNode(0);
      curr->parent->last = curr->next;
      curr->next->parent = curr->parent;
      curr = curr->next;
    }
    strcpy(curr->id, id);
    strcpy(curr->value, txt);
  }
  return curr;
}

gint newinfo_cb(GtkWidget *button, newuserinfo_data *uinfo)
{
  Node *curr;
  Node *current;
  GtkWidget *top;

  if (!cf) {
    /* we have no config file yet,
     * create one
     */
    cf = newNode(0);
    strcpy(cf->id, "fingerconf");
    cf->child = newNode(0);
    cf->last = cf->child;
    curr = cf->child;
    curr->parent = cf;
    strcpy(curr->id, "userinfo");
    /* init the new node */
    curr->child = newNode(0);
    curr->last = curr->child;
    curr->child->parent = curr;
    curr = curr->child;
  }
  else {
    /* we already have a cf file 
     * we drop the old userinfo and create the new one
     */

    curr = cf->child;
    while(curr) {
      if (!strcmp(curr->id, "userinfo")) {
	FreeParseTree(curr->child);
	break;
      }
      curr = curr->next;
    }
    if (!curr)
      if ((curr = cf->child)) {
	while (curr->next) 
	  curr = curr->next;
	curr->next = newNode(0);
	curr->parent->last = curr->next;
      }
      else {
	/* this is a very strange case... */
	FreeParseTree(cf);
	cf = NULL;
	newinfo_cb(button, uinfo);
	return FALSE;
      }
    else {
      /* init the new node */
      curr->child = newNode(0);
      curr->last = curr->child;
      curr->child->parent = curr;
      curr = curr->child;
    }
  }
  
  curr = addentry2node(uinfo->first, curr, "first");
  curr = addentry2node(uinfo->last, curr, "last");
  curr = addentry2node(uinfo->nick, curr, "nick");
  curr = addentry2node(uinfo->email, curr, "email");
  curr = addentry2node(uinfo->homepage, curr, "homepage");

  if (!strlen(curr->id)) {
    /* all entries were empty */
    FreeParseTree(cf);
    cf = NULL;
  }

  oldnode = NULL;

  /* recreate the userinfo tree */
  gtk_tree_clear_items(uinfo->tree, 0, 1);
  top = gtk_tree_item_new_with_label("Userinfo");
  gtk_widget_show(top);
  gtk_tree_append(uinfo->tree, top);
  if (cf) {
    current = cf->child;
    while (current) {
      if (!strcmp(current->id, "userinfo"))
      make_subtree(current->child, top);
      current = current->next;
    }
  }
  GTK_TREE_SELECTION (uinfo->tree) = NULL;  

  free(uinfo);
  return FALSE;
}

void NewUserinfo(gpointer data, gpointer tree)
{
  GtkWidget *dialog;
  GtkWidget *vbox;
  GtkWidget *label;
  GtkWidget *entry;
  GtkTable *table;
  GtkWidget *button;
  newuserinfo_data *uinfo;

  /* init data structure */
  if (!(uinfo = (newuserinfo_data *)malloc(sizeof(newuserinfo_data))))
    return;

  /* Init the dialog window */
  dialog = gtk_window_new( GTK_WINDOW_DIALOG );
  gtk_window_set_title(GTK_WINDOW( dialog ), "New Userinfo");

  /* set initial position */
  gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
  gtk_widget_set_usize(dialog, 300, 250);

  /* create the daddy box */
  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(dialog), vbox);
  gtk_widget_show(vbox);

  /* a help label */
  label = gtk_label_new( "Fill in all fields that apply for you." );
  gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 5 );
  gtk_misc_set_alignment( GTK_MISC( label ), 0.5, 1 );
  gtk_widget_show( label );

  label = gtk_label_new( "Leave the other fields empty." );
  gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 5 );
  gtk_misc_set_alignment( GTK_MISC( label ), 0.5, 1 );
  gtk_widget_show( label );

  /* Should we use a notebook ? */

  /* table for a beatyful alignement */
  table = (GtkTable *)gtk_table_new(5, 2, FALSE);
  gtk_container_add(GTK_CONTAINER(vbox), (GtkWidget *)table);
  gtk_widget_show((GtkWidget *)table);

  /* First name */
  label = gtk_label_new( "First Name: " );
  entry = gtk_entry_new();
  gtk_table_attach(table, label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
  gtk_table_attach(table, entry, 1, 2, 0, 1, GTK_FILL, 0, 0, 0 );
  gtk_widget_show(label);
  gtk_widget_show(entry);
  uinfo->first = (GtkEntry *)entry;
  gtk_widget_grab_focus(entry);

  /* Last name */
  label = gtk_label_new( "Last Name: " );
  entry = gtk_entry_new();
  gtk_table_attach(table, label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0 );
  gtk_table_attach(table, entry, 1, 2, 1, 2, GTK_FILL, 0, 0, 0 );
  gtk_widget_show(label);
  gtk_widget_show(entry);
  uinfo->last = (GtkEntry *)entry;

  /* Nick name */
  label = gtk_label_new( "Nick Name: " );
  entry = gtk_entry_new();
  gtk_table_attach(table, label, 0, 1, 2, 3, GTK_FILL, 0, 0, 0 );
  gtk_table_attach(table, entry, 1, 2, 2, 3, GTK_FILL, 0, 0, 0 );
  gtk_widget_show(label);
  gtk_widget_show(entry);
  uinfo->nick = (GtkEntry *)entry;

  /* e-mail */
  label = gtk_label_new( "e-mail: " );
  entry = gtk_entry_new();
  gtk_table_attach(table, label, 0, 1, 3, 4, GTK_FILL, 0, 0, 0 );
  gtk_table_attach(table, entry, 1, 2, 3, 4, GTK_FILL, 0, 0, 0 );
  gtk_widget_show(label);
  gtk_widget_show(entry);
  uinfo->email = (GtkEntry *)entry;

  /* homepage */
  label = gtk_label_new( "Homepage: " );
  entry = gtk_entry_new();
  gtk_table_attach(table, label, 0, 1, 4, 5, GTK_FILL, 0, 0, 0 );
  gtk_table_attach(table, entry, 1, 2, 4, 5, GTK_FILL, 0, 0, 0 );
  gtk_widget_show(label);
  gtk_widget_show(entry);
  uinfo->homepage = (GtkEntry *)entry;

  /* home */

  /* office */

  /* other callback data */
  uinfo->tree = (GtkTree *)tree;

  /* OK and Cancel buttons */
  button = gtk_button_new_with_label( "OK" );
  gtk_signal_connect( GTK_OBJECT( button ), "clicked", 
		      GTK_SIGNAL_FUNC( newinfo_cb ), 
		      uinfo ); 
  gtk_signal_connect_object( GTK_OBJECT( button ), "clicked", 
			     GTK_SIGNAL_FUNC( gtk_widget_destroy ), 
			     GTK_OBJECT( dialog ) ); 
  gtk_widget_set_usize( button, 100, 30 );
  gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 5 );
  gtk_widget_show( button );

  button = gtk_button_new_with_label( "Cancel" );
  gtk_signal_connect_object( GTK_OBJECT( button ), "clicked", 
			     GTK_SIGNAL_FUNC( gtk_widget_destroy ), 
			     GTK_OBJECT( dialog ) ); 
  gtk_widget_set_usize( button, 100, 30 );
  gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 5 );
  gtk_widget_show( button );

  gtk_widget_show(dialog);
}
