/* PIPServer - A deamon for finger protocol v2
 *
 * Copyright (C) 1999 Michael Baumer <baumi@vis.ethz.ch>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* $Id: configfile.c,v 1.12 2001/07/01 14:16:29 baumi Exp $
 *
 * Description:
 *
 * Read a finger config file 
 */

#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include "parser.h"
#include "file.h"
#include "finger.h"
#include "log.h"

#ifndef S_IROTH 
/* grumble... */
#define S_IROTH  00004
#define S_IRGRP  00040
#define S_IRUSR  00400
#define S_IWUSR  00200
#endif

#define GLOBAL_FINGERCONF "/etc/fingerconf"

char *configfile = GLOBAL_FINGERCONF;
Node * readconfig(char *filename);

/* Read a fingerconf for a user
 *
 * If filename is NULL, read the global fingerconf 
 */
Node * readFingerconf(char *filename)
{
  char *confid = "<fingerconf>";
  int fd;
  char buf[20];
  Node *node;
  int len;

  if (!filename)
    filename = configfile;

  if ((fd = open(filename, O_RDONLY)) < 0 )
    return 0;

  /* Verify file */
  len = strlen(confid);

  if (read(fd, buf, len) < len) {
    log(LOG_ERR, "While reading from %s:%m", filename);
    close(fd);
    return 0;
  }
  else {
    buf[len] = '\0';
    /*
    if (strcmp(buf, confid)) {
      log(LOG_ERR, "File %s exists but is not a valid fingerconf", 
	  filename);
      close(fd);
      return 0;
    }
    */
  }

  /* Init node */
  node = (Node *)malloc(sizeof(Node));

  if (!node)
    return 0;

  node->next = NULL;
  node->child = NULL;
  node->last = NULL;
  node->parent = NULL;
  strcpy(node->id, "fingerconf");
  node->type = 0;
  node->value = (char *)malloc(BUFSIZE);

  if (!node->value) {
    free(node);
    return 0;
  }

  node->val_len = BUFSIZE;

  ParseNode(fd, node);

  return node;
}

void writeFingerconf(char *filename, Node *node)
{
  int fd;
  char buf[MAX_ID_LEN + 10];

  if (!node)
    return;

  fd = open(filename, (O_WRONLY | O_CREAT | O_TRUNC), 
	    (S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH));

  if (fd < 0)
    return;

  while(node) {
    sprintf(buf, "<%s>\n", node->id);
    write(fd, buf, strlen(buf));
    write(fd, node->value, strlen(node->value));
    if (node->child)
      node = node->child;
    else {
      if (node->next) {
	sprintf(buf, "</%s>\n", node->id);
	write(fd, buf, strlen(buf));
	node = node->next;
      }
      else {
	while(node && !node->next) {
	  sprintf(buf, "</%s>\n", node->id);
	  write(fd, buf, strlen(buf));
	  node = node->parent;
	}
	if (node) {
	  sprintf(buf, "</%s>\n", node->id);
	  write(fd, buf, strlen(buf));
	  node = node->next;
	}
      }
    }
  }
  close(fd);
}
