/* PIPClient - A client for finger protocol v2
 *
 * Copyright (C) 1999 Michael Baumer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif /* HAVE_STRINGS_H */

#ifndef HAVE_GETOPT_DECL
int getopt(int argc, char **argv, char *optstring);
extern char *optarg;
extern int optind;
#endif 

#include "conn.h"
#include "compat.h"

void DoFinger1(char *hostname, char *query)
{
  int s, nread;
  static char buf[80*20 + 1];
  char *res_host;

  if ((s = make_conn(hostname, &res_host)) < 0)
    return;

  if (strcmp(hostname, "localhost"))
    printf("[%s]\n", res_host);

  write(s, query, strlen(query));

  while ((nread = read(s, buf, sizeof(buf) - 1)) > 0) {
    buf[nread] = '\0';
    printf("%s", buf);
  }

  close(s);
}

void Usage(char *progname)
{
  printf("Usage: %s [-c file] [-h] [-V] [-d] [-t]\n", progname);
  printf("\t-h\tprint this screen and exit\n"
	 "\t-V\tprint version number and exit\n"
	 /*
	 "\t-c file\tuse \"file\" as configuration file\n"
	 "\t-d\tdebug modus\n"
	 */
	 "\t-t\ttest modus: start in.fingerd locally\n");
}

int main( int   argc, char *argv[] )
{
  int flag;
  char *progname;
  int info = 0;
  char *hostname;
  char *query;

  /* extraxt base name */
  progname = strrchr(argv[0], '/');
  if (!progname)
    progname = argv[0];
  else
    progname++;

  /* parse the command line arguments */
  while ((flag = getopt(argc, argv,
			"lc:Vdght")) != EOF) 
    switch (flag) {
    case 'c':
      /*
      configfile = strdup(optarg);
      */
      break;
    case 'l':
      info = 1;
      break;
    case 'V':
      printf("%s: %s Version %s\n", progname, PACKAGE, VERSION);
      exit(0);
    case 'd':
      /*
      debug = 1;
      */
      break;
    case 'g':
      /*
      gnufinger = 1;
      */
      break;
    case 't':
      /*
      test = 1;
      */
      break;
    case 'r':
      /*
      realnames = 1;
      */
      break;
    case 'h':
    default:
      Usage(progname);
      exit(0);
      break;
    }

  /* optind now points to the first username */
  if (optind < argc) {

    /* todo: make an array of users of each host to finger */

    while (optind < argc) {
      hostname = strrchr(argv[optind], '@');    /* parse from behind */
      if (!hostname || !*hostname)
	hostname = "localhost";
      else {
	*hostname = '\0';
	hostname++;
      }

      query = malloc(strlen(argv[optind]) + 10);
      if (query) {
	sprintf(query, "%s%s\r\n", (info) ? "/W " : "", argv[optind]);

	DoFinger1(hostname, query);

	free(query);
      }
      optind++;
    }
  }
  else {
    /* send empty string to localhost */
    hostname = "localhost";
    DoFinger1(hostname, "\r\n");
  }

  return 0;
}
