/* PIPServer - A deamon for finger protocol v2
 *
 * Copyright (C) 1999 Michael Baumer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef FINGER_H
#define FINGER_H

#include <sys/types.h>

#include "utmplib.h"
#ifndef UT_NAMESIZE
#define UT_NAMESIZE 16
#endif

/* This structure contains information about the user
 * 
 * It is defined so, that if no user information is available,
 * it can be emulated by reading the passwd file (Read: we have a
 * field "realname")
 */

typedef struct finger_userinfo {
  char *pw_name;
  char *pw_realname;
  char *office;
  char *office_phone;
  char *home_phone;
  char *homedir; /* this will not be printed, but is used to find the users
		  * configuration files */
} finger_userinfo;


/* This structure contains information about who is logged in
 * 
 * It contains no data that would have to be looked up in the users
 * configuration 
 */

#define HOSTNAME_LEN 64
#define REALNAME_LEN 64
#define STATUS_LEN 16

typedef struct login_info {
  time_t login_time;
  char login_user[UT_NAMESIZE];
  char realname[REALNAME_LEN];
  char hostname[HOSTNAME_LEN];
  char fromhost[HOSTNAME_LEN];
  time_t idle_time;
  char status[STATUS_LEN];
  struct login_info *next;
} login_info;

typedef struct field_perm {
  int tty;
  int login;
  int idle;
  int mail;
} field_perm;

struct aclT; /* defined in acl.h */

typedef struct fingerconf {
  unsigned int first_uid; /* first uid to finger */
  int gnufinger; /* are we in gnufinger mode */
  int interval;  /* interval for site server */
#if 0
  int userlist;  /* show userlist (`finger @host`) */
  int showidle;  /* Show idle time */
  int showfrom;  /* Show from host */
  int hidemail;  /* Hide mail status */
  int hideall;   /* Disable "all" requests */
#endif
  int clusterType; /* 0: not on a cluster, 1: client, 2: master */
  char *siteinfo;
  char *help;
  char *validfile[11];
  char *filedesc[10];
  char *userfilepath[4];
  char *dbpath;
  char *gnufingerdir;
  char *sitehost;
  int numclients;
  char **clients;
  struct aclT *acl; /* Access Control List */
  struct aclT *allow;
  struct aclT *deny;
  int aclorder;     /* 0 = deny,allow ; 1 = allow,deny */
} fingerconf;

extern fingerconf config;

#endif /* FINGER_H */
