/* PIPServer - A client for finger protocol v2
 *
 * Copyright (C) 1999 Michael Baumer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#include <string.h>

#include "request.h"
#include "conn.h"

GtkWidget *list;
GtkWidget *cur_text;
GtkWidget *statusbar;
GdkFont *bfont;
GdkFont *slfont;

#if (GTK_MAJOR_VERSION == 1) && (GTK_MINOR_VERSION == 0)
#define gtk_window_set_position gtk_window_position
#define gtk_container_set_border_width gtk_container_border_width
#endif

extern int test;
extern void poll_servers();
extern void test_connection(int debug, char *cmd);
extern void ChangeUserinfo();

/* Forward declarations */

void ShowUserinfo(char *username);
void GenericFinger();
void addText(char *txt, int font);

gint poll_timeout(gpointer data);
gint list_cb( GtkWidget *clist, GdkEventButton *event, gpointer data );
gint status_cb( GtkWidget *clist, GdkEventButton *event, gpointer data );

gint delete_event( GtkWidget *widget,
		   GdkEvent  *event,
		   gpointer   data )
{
  /* Destroy main window */  
  return(FALSE);
}

void destroy( GtkWidget *widget,
	      gpointer   data )
{
  /* exit the program */
  gtk_main_quit();
}

#if (GTK_MAJOR_VERSION == 1) && (GTK_MINOR_VERSION == 0)

GtkWidget *create_menu(GtkWidget *window, GtkWidget *clist)
{
  GtkMenuEntry menu_items[] = {
    { "<Main>/Finger",         NULL,         NULL, 0 },
    { "<Main>/Finger/Finger", "<control>F", GenericFinger, 0 },
    { "<Main>/Finger/<separator>",     NULL,         NULL, 0  },
    { "<Main>/Finger/Quit",     "<control>Q", gtk_main_quit, 0 },
    { "<Main>/Info",      NULL,         NULL, 0 },
    { "<Main>/Info/Change Userinfo",  "<control>U", ChangeUserinfo, 0 },
    /*
    { "<Main>/Info/<separator>",     NULL,         NULL, 0 },
    { "<Main>/Info/Show Userinfo", "<control>I", ShowUserinfo_menu, 
      GPOINTER_TO_UINT(clist) },
    */
    { "<Main>/Help",         NULL,         NULL, 0 },
    { "<Main>/Help/About",   NULL,         NULL, 0 },
  };    
  GtkMenuFactory *factory;
  GtkMenuFactory *subfactory;
  int nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);

  factory = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
  subfactory = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
  
  gtk_menu_factory_add_subfactory(factory, subfactory, "<Main>");
  gtk_menu_factory_add_entries(factory, menu_items, nmenu_items);
  gtk_window_add_accelerator_table(GTK_WINDOW(window), subfactory->table);

  return(subfactory->widget);
}

#else

GtkWidget *create_menu(GtkWidget *window, GtkWidget *clist)
{
  GtkItemFactoryEntry menu_items[] = {
    { "/_Finger",         NULL,         NULL, 0, "<Branch>" },
    { "/Finger/_Finger", "<control>F", GenericFinger, 0, NULL},
    { "/Finger/sep1",     NULL,         NULL, 0, "<Separator>" },
    { "/Finger/_Quit",     "<control>Q", gtk_main_quit, 0, NULL },
    { "/_Info",      NULL,         NULL, 0, "<Branch>" },
    { "/Info/_Change Userinfo",  "<control>U", ChangeUserinfo, 0, NULL },
    /*
    { "/Info/sep2",     NULL,         NULL, 0, "<Separator>" },
    { "/Info/_Show Userinfo", "<control>I", ShowUserinfo_menu, 
      GPOINTER_TO_UINT(clist), NULL },
    */
    { "/_Help",         NULL,         NULL, 0, "<LastBranch>" },
    { "/_Help/_About",   NULL,         NULL, 0, NULL },
  };    
  gint nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);
  GtkAccelGroup *accel_group;
  GtkItemFactory *item_factory;

  accel_group = gtk_accel_group_new ();

  item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", 
				       accel_group);
  gtk_item_factory_create_items (item_factory, nmenu_items, menu_items, NULL);
  gtk_accel_group_attach (accel_group, GTK_OBJECT (window));

  return gtk_item_factory_get_widget (item_factory, "<main>");
}

#endif /* GTK_MAJOR_VERSION == 1  && GTK_MINOR_VERSION == 0 */

void create_gui_gtk()
{
  GtkWidget *mainWindow;
  GtkWidget *scw;
  GtkWidget *menubar;
  GtkWidget *box;
  GtkWidget *event_box;
  char *progname = "PFinger";
  char *deftext[] = { "Name", "Status" };

  /* create a new window */
  mainWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW(mainWindow), progname);

  /* let the user resize the window */
  gtk_window_set_policy( GTK_WINDOW( mainWindow ), TRUE, TRUE, FALSE );
  gtk_widget_realize(mainWindow);

  /* set the coordinates */
  gtk_window_set_position( GTK_WINDOW(mainWindow), GTK_WIN_POS_NONE );
  gtk_widget_set_uposition( mainWindow, 500, 200 ); 
  gtk_widget_set_usize( mainWindow, 150, 300 );

  /* on delete */
  gtk_signal_connect (GTK_OBJECT (mainWindow), "delete_event",
		      GTK_SIGNAL_FUNC (delete_event), NULL);

  gtk_signal_connect (GTK_OBJECT (mainWindow), "destroy",
		      GTK_SIGNAL_FUNC (destroy), NULL); 

  /* Sets the border width of the window. */
  gtk_container_set_border_width (GTK_CONTAINER (mainWindow), 1);

  /* make the papa box */
  box = gtk_vbox_new(FALSE, 0);
  gtk_container_add( GTK_CONTAINER(mainWindow), box);
  gtk_widget_show( box );

  /* create the list in advance */
  list = gtk_clist_new(2);

  /* make the menu */
  menubar = create_menu(mainWindow, list);
  gtk_box_pack_start (GTK_BOX (box), menubar, FALSE, FALSE, 0);
  gtk_widget_show (menubar);

  /* make the userlist */
  
  scw = gtk_scrolled_window_new( NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scw),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start( GTK_BOX( box ), scw, TRUE, TRUE, 0 );
  gtk_widget_show (scw);

  /* create the list */
  gtk_clist_set_selection_mode(GTK_CLIST(list), GTK_SELECTION_SINGLE);
  gtk_clist_append(GTK_CLIST(list), deftext);
  gtk_clist_set_column_width(GTK_CLIST(list), 0, 80);
  gtk_clist_set_column_width(GTK_CLIST(list), 1, 30);

  /* Add the list */
  gtk_container_add(GTK_CONTAINER(scw), list);
  gtk_widget_show(list);

  /* List callbacks */
  gtk_signal_connect( GTK_OBJECT( list ), "button_press_event",
		      GTK_SIGNAL_FUNC( list_cb ), NULL);

  /* Create a status bar 
   * and put it in an event box 
   */
  statusbar = gtk_statusbar_new();
  gtk_widget_set_usize( statusbar, 0, 20 );
  gtk_statusbar_push( GTK_STATUSBAR( statusbar ), 1, "Online" );

  event_box = gtk_event_box_new();
  gtk_container_add( GTK_CONTAINER(event_box), statusbar );
  gtk_box_pack_end( GTK_BOX( box ), event_box, FALSE, FALSE, 0 );
  gtk_widget_show( event_box );
  gtk_widget_show( statusbar );

  /* connect the statusbar callback */
  gtk_signal_connect( GTK_OBJECT( event_box ), "button_press_event",
		      GTK_SIGNAL_FUNC( status_cb ), NULL);

  /* Show the main window */
  gtk_widget_show(mainWindow);

  /* set initial position */
  gtk_window_set_position(GTK_WINDOW(mainWindow), GTK_WIN_POS_MOUSE);

  /* add the timeout */
  /* Once every minute */
  gtk_timeout_add(60000,
		  poll_timeout, 
		  NULL);

  bfont = gdk_font_load("-*-*-bold-r-normal-*-*-*-*-*-p-*-iso8859-1");
  slfont = gdk_font_load("-*-*-medium-o-*-sans-*-140-*-*-p-*-iso8859-1");
}

void gui_add_user(char *name, int status)
{
  char *entry[2];

  /* check if user is already in list */
  /* todo... */

  entry[0] = name;
  switch (status) {
  case 0:
    entry[1] = "idle";
    break;
  case 1:
    entry[1] = "active";
    break;
  case 2:
    entry[1] = "online";
    break;
  }
  gtk_clist_append(GTK_CLIST(list), entry);
}

gint poll_timeout(gpointer data)
{
  char *deftext[] = { "Name" , "Status" };

  gtk_clist_freeze(GTK_CLIST(list));

  gtk_clist_clear( GTK_CLIST(list) );
  gtk_clist_append(GTK_CLIST(list), deftext);
  
  poll_servers();
  gtk_clist_thaw(GTK_CLIST(list));

  return TRUE;
}

gint list_cb( GtkWidget *clist, GdkEventButton *event, gpointer data )
{
  int row, column;
  char *username;

  /* we do something if:
     - doubleclick
     - middle mouse button */
  
  if(  event->type != GDK_2BUTTON_PRESS && event->button == 1 )
    return FALSE;
  
  if( event->type != GDK_BUTTON_PRESS && event->button == 3 )
    return FALSE;
    
  if (event->button == 3) {

    /* make a popup menu */

    /* todo

    return FALSE;
    */
  }

  /* retrieve user */
  gtk_clist_get_selection_info( GTK_CLIST( clist ), 
				event->x, event->y,
				&row, &column );
  
  if ((gtk_clist_get_text(GTK_CLIST( clist ), row, 0, &username)) &&
      (row > 0))
    ShowUserinfo(username);
  else
    GenericFinger();

  /* retrieve message type to send */
  /* we only support e-mail so far */

  /* open message window */
  
  return FALSE;
}

gint change_status( gpointer button, gpointer data )
{
  if (GPOINTER_TO_INT(data)==1)
    gtk_main_quit();

  return FALSE;
}

/* status_cb
 *
 * Called after the user clicked on the status bar. Creates a popup menu
 * that contains the possible online-states.
 */
gint status_cb( GtkWidget *clist, GdkEventButton *event, gpointer data )
{
  GtkWidget *item;
  GtkWidget *menu;
  GdkEventButton *bevent = (GdkEventButton *) event;
  char *state_name[] = { "Online", "Offline", NULL };
  int i = 0;

  menu = gtk_menu_new();
  
  while(state_name[i]) {
    item = gtk_menu_item_new_with_label( state_name[i] );
    gtk_menu_append( GTK_MENU( menu ), item );
    gtk_signal_connect( GTK_OBJECT( item ), "activate",
			GTK_SIGNAL_FUNC( change_status ), 
			GINT_TO_POINTER(i) );
    gtk_widget_show( item );
    i++;
  }
  
  gtk_menu_popup( GTK_MENU( menu ), NULL, NULL, NULL, NULL,
		  bevent->button, bevent->time );

  return FALSE;
}

gint finger_cb( GtkWidget *entry,
		GtkWidget *widget)
{
  char *username;

  username = gtk_entry_get_text(GTK_ENTRY(entry));
  if (username && strlen(username))
    ShowUserinfo(username);

  /* Destroy window */  
  return(FALSE);
}

void GenericFinger()
{
  GtkWidget *dialog;
  GtkWidget *entry;
  GtkWidget *vbox;
  GtkWidget *label;
  GtkWidget *button;
  
  /* Init the dialog window */

  dialog = gtk_window_new( GTK_WINDOW_DIALOG );
  gtk_window_set_title(GTK_WINDOW( dialog ), "Finger User");

  /* set initial position */
  gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);

  vbox = gtk_vbox_new( FALSE, 0 );
  gtk_container_add( GTK_CONTAINER( dialog ), vbox );
  
  label = gtk_label_new( "Enter the user to finger:" );
  
  gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 5 );
  gtk_misc_set_alignment( GTK_MISC( label ), 0.5, 1 );
  gtk_widget_show( label );       

  entry = gtk_entry_new();
  gtk_box_pack_start( GTK_BOX( vbox ), entry, FALSE, FALSE, 5 );
  gtk_widget_show( entry ); 
  gtk_widget_grab_focus( entry );  

  button = gtk_button_new_with_label( "OK" );
  GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
  gtk_signal_connect_object( GTK_OBJECT( button ), "clicked", 
			     GTK_SIGNAL_FUNC( finger_cb ), 
			     GTK_OBJECT( entry ) ); 
  gtk_signal_connect_object( GTK_OBJECT( button ), "clicked", 
			     GTK_SIGNAL_FUNC( gtk_widget_destroy ), 
			     GTK_OBJECT( dialog ) ); 
  gtk_widget_set_usize( button, 100, 30 );
  gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 5 );
  gtk_widget_show( button );

  gtk_widget_show( vbox );
  
  gtk_widget_set_usize( dialog, 200, 100 );
 
  gtk_widget_show( dialog );

}

void ShowUserinfo(char *username)
{
  int s;
  GtkWidget *dialog;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *text;
  GtkWidget *vscrollbar;
  char cmd[120];
  char *hostname;
  int nread;
  char buf[100];
  static int x = 200;
  static int y = 100;

  /* Get hostname */
  hostname = index(username, '@');
  if (hostname)
    hostname++;
  else
    /* todo: make this the users default host */
    hostname = "localhost";

  s = make_conn(hostname, NULL);

  if (s<0) 
    return;

  /* Init the dialog window */

  dialog = gtk_window_new( GTK_WINDOW_DIALOG );
  gtk_window_set_title(GTK_WINDOW( dialog ), "Userinfo");
  
  gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_NONE);
  gtk_widget_set_uposition(dialog, x, y);
  x = (x + 20) % 600;
  y = (y + 20) % 400;
  
  vbox = gtk_vbox_new( FALSE, 0 );
  gtk_container_add( GTK_CONTAINER( dialog ), vbox );
  
  label = gtk_label_new( "User Information" );
  
  gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 5 );
  gtk_misc_set_alignment( GTK_MISC( label ), 0.5, 1 );
  gtk_widget_show( label );       

  text = gtk_text_new( NULL, NULL );
  
  hbox = gtk_hbox_new( FALSE, 0 );
  gtk_box_pack_start( GTK_BOX( hbox ), text, TRUE, TRUE, 0 );
  gtk_widget_show( text );
  
  vscrollbar = gtk_vscrollbar_new (GTK_TEXT(text)->vadj);
  gtk_box_pack_start(GTK_BOX(hbox), vscrollbar, FALSE, FALSE, 0);
  gtk_widget_show (vscrollbar); 
  
  gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, TRUE, 5 );
  gtk_widget_show( hbox );

  button = gtk_button_new_with_label( "OK" );
  gtk_signal_connect_object( GTK_OBJECT( button ), "clicked", 
			     GTK_SIGNAL_FUNC( gtk_widget_destroy ), 
			     GTK_OBJECT( dialog ) ); 
  gtk_widget_set_usize( button, 100, 30 );
  gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 5 );
  gtk_widget_show( button );

  gtk_widget_show( vbox );
  
  gtk_widget_set_usize( dialog, 480, 260 );
 
  gtk_widget_show( dialog );

  cur_text = text;

  /* get the text */

  sprintf(cmd, "<finger><user>%s</user></finger></pip>", username);
  if (!test) {
    if (!send_request(s, s, cmd)) {
      close(s);
      if ((s = make_conn(hostname, NULL)) < 0)
	return;
      sprintf(cmd, "/W %s\r\n", username);
      write(s, cmd, strlen(cmd));
      while((nread = read(s, buf, 99)) > 0) {
	buf[nread]='\0';
	if (nread)
	  addText(buf, 0);
      }
      close(s);
    }
  }
  else
    test_connection(0, cmd);
  
  close(s);
}

void addText(char *txt, int font)
{
  GdkFont *fnt;

  if (test) {
    printf("%s\n", txt);
    return;
  }
  switch (font) {
  case 1:
    fnt = bfont;
    break;
  case 2:
    fnt = slfont;
    break;
  default:
    fnt = NULL;
  }

  gtk_text_freeze (GTK_TEXT (cur_text));	  
  gtk_text_insert(GTK_TEXT(cur_text), fnt, NULL, NULL,
		  txt, -1);
  gtk_text_thaw (GTK_TEXT (cur_text));	  
}
