/* PIPServer - A deamon for finger protocol v2
 *
 * Copyright (C) 2001-2003 Michael Baumer <baumi@vis.ethz.ch>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include <syslog.h>
#include <stdio.h>
#include <stdarg.h>

#include "log.h"

static int _log_type = LOGTYPE_STDERR;
static char *syslog_mem;

#ifdef HAVE_VSNPRINTF
#define SYSLOG_LEN 160
#else
#define SYSLOG_LEN 1024
#endif

void log_open(char *progName, int type)
{
  _log_type = type;

  if (_log_type == LOGTYPE_SYSLOG) {
     openlog(progName, LOG_PID, LOG_DAEMON);
     syslog_mem = (char *)malloc(SYSLOG_LEN);
  }
}

void log_close()
{
  if (_log_type == LOGTYPE_SYSLOG) {
    closelog();
  }
}

/* Output a log message
 *
 */
void log(int level, char *fmt, ...)
{
  va_list arg;

  va_start(arg, fmt);

  if (_log_type == LOGTYPE_SYSLOG) {
#ifdef HAVE_VSNPRINTF
    vsnprintf(syslog_mem, SYSLOG_LEN-1, fmt, arg);
#else
    /* NOTE: This is a bit unsafe 
     * but we don't want to write vsnprintf on our own yet 
     */
    vsprintf(syslog_mem, fmt, arg);
#endif
    syslog(level, "%s", syslog_mem);
  } else {
    switch (level) {
    case LOG_ERR:
      fprintf(stderr, "[ERROR]: ");
      break;
    case LOG_WARNING:
      fprintf(stderr, "[WARNING]: ");
      break;
    case LOG_INFO:
      fprintf(stderr, "[INFO]: ");
      break;
    case LOG_DEBUG:
      fprintf(stderr, "[DEBUG]: ");
      break;
    }
   
    vfprintf(stderr, fmt, arg);
    fprintf(stderr, "\n");
  }

  va_end(arg);
}
