/* PIPServer - A deamon for finger protocol v2
 *
 * Copyright (C) 2001 Michael Baumer <baumi@vis.ethz.ch>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* utility functions for writing error messages to 
   syslog or stderr 
*/

#ifndef LOG_H
#define LOG_H

#include <syslog.h> /* Nedded for LOG_xy defines */

#define LOGTYPE_SYSLOG 1
#define LOGTYPE_STDERR 2

/* Set the type of log to use (syslog or stderr) */
void log_open(char *progName, int type);
void log_close();

/* output an error message */
void log(int level, char *fmt, ...);

#endif /* LOG_H */
