/* PIPServer - A deamon for finger protocol v2
 *
 * Copyright (C) 1999 Michael Baumer <baumi@vis.ethz.ch>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>

#ifdef HAVE_PATHS_H
#include <paths.h>
#endif /* HAVE_PATHS_H */
#include <stdio.h>
#include <time.h>
#include <ctype.h>
#include <string.h>

#include "finger.h"
#include "parser.h"
#include "local_user.h"
#include "statusdb.h"
#include "in.fingerd.h"

/* answer to a login request 
 *
 * subpackets: <user> the username
 *             <passwd> the unencypted password
 *
 * todo: check permission of requesting party
 */

void login_handler(Node *node)
{
  Node *subnode;
  char *username = NULL;
  char *passwd = NULL;
  char *hostname = NULL;
  char *tmp;
  login_info *linfo, *current;
  time_t idle;

  fprintf(stdout, "<login_reply>\n");

  if (node->child) {
    subnode = node->child;
    while(subnode) {
      if (!strcmp(subnode->id, "user")) {
	
	username = subnode->value;
	/* entspace it */
	while (*username && isspace(*username))
	  username++;
	tmp = username + strlen(username) - 1;
	while((tmp >= username) && (isspace(*tmp))) {
	  *tmp = '\0';
	  tmp--;
	}
      }
      else if (!strcmp(subnode->id, "passwd")) {
	passwd = subnode->value;
      }
      else if (!strcmp(subnode->id, "hostname")) {
	hostname = subnode->value;
      }

      subnode = subnode->next;
    }
  }

  if ((!passwd) || (!username)) {
    /* this must be an error */
    fprintf(stdout, "<error>Username or Password missing</error>\n");
  }
  else {
    /* search for that login */

    if (!hostname)
      hostname = conn.hostname;

    switch (db_login(username, passwd, hostname)) {
    case -1:
      fprintf(stdout, "<error>Wrong username or password</error>\n");
      break;
    case 0:
      fprintf(stdout, "<error>Internal error</error>\n");
      break;
    case 1:
      fprintf(stdout, "<ok>Login Sucessful</ok>\n");
      break;
    }
  }
  
  fprintf(stdout, "</login_reply>\n");
}
