/* PIPServer - A deamon for finger protocol v2
 *
 * Copyright (C) 1999 Michael Baumer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * $Id: statusdb.h,v 1.4 1999/10/24 13:39:09 baumi Exp $
 */

#ifndef STATUSDB_H
#define STATUSDB_H

#include "finger.h"

/* internal declaration, declared here for macros and for the
 * fingerd
 * DO NOT use it directly in other cases
 */

/* what the db looks like */

typedef struct db_entry {
  int flag;
  time_t login_time;
  /* idle_time really is the last update time */
  time_t idle_time; 
  char login_user[UT_NAMESIZE];
  char realname[REALNAME_LEN];
  char hostname[HOSTNAME_LEN];
  char fromhost[HOSTNAME_LEN];
  char status[STATUS_LEN];
  char passwd[13];
  /* for lists of this structure */
  struct db_entry *next;
} db_entry;

login_info * read_utmp_db(int sorted);
int write_entry();
int db_add_user(char *username, char *passwd, char *hostname);
int db_login(char *username, char *passwd, char *hostname);
int db_logout();

/* for the fingerd */
int db_insertlist(db_entry *list);

/* Change Entry functions/macros */
#define setEntry_status(x) strcpy(_entry.status, x)
#define setEntry_realname(x) strcpy(_entry.realname, x)
#define setEntry_login(x) strcpy(_entry.login_user, x)
#define setEntry_hostname(x) strcpy(_entry.hostname, x)
#define setEntry_login_time(x) (_entry.login_time = x)
#define setEntry_idle_time(x) (_entry.idle_time = x)

/* Do not use directly! */
extern db_entry _entry;

#endif /* STATUSDB_H */
