/* PIPServer - A deamon for finger protocol v2
 *
 * Copyright (C) 1999 Michael Baumer <baumi@vis.ethz.ch>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* $Id: utmplib.h,v 1.1 2000/07/30 09:56:27 baumi Exp $
 *
 * Description:
 *
 * Provides the utmp access routines (setutent, getutent, endutent) for
 * systems that do not have them (e.g. NetBSD 1.3).
 * If the system provides these function don't get compiled in the 
 * binary.
 */

#ifndef UTMPLIB_H
#define UTMPLIB_H

#include <config.h>

#ifdef HAVE_UTMPX_H

#include <utmpx.h>
/* We assume utmpx provides a 
 * complete structure
 */
#ifndef HAVE_UT_HOST
#define HAVE_UT_HOST 1
#endif
#ifndef ut_time
#define ut_time ut_tv.tv_sec
#endif

#define my_utmp utmpx

#define my_setutent setutxent
#define my_endutent endutxent
#define my_getutent getutxent

#else
#include <utmp.h>

#ifndef HAVE_SETUTENT

void setutent(void);
void endutent(void);
struct utmp *getutent(void);

#endif /* HAVE_SETUTENT */

#define my_utmp utmp

#define my_setutent setutent
#define my_endutent endutent
#define my_getutent getutent

#endif /* HAVE_UTMPX_H */

#endif /* UTMPLIB_H */
