#include "finger.h"
#include "acl.h"

aclT * findACLbytype(aclT *acl, int type)
{
  while(acl) {
    if (acl->type == type)
      return(acl);
    acl = acl->next;
  }
  return(0);
}

aclT * findACLbyhost(aclT *acl, char *hostname, char *ipaddr)
{
  while(acl) {
    if (acl->type == ACLTYPE_IP) {
      if (!strcmp(acl->from, ipaddr))
	return(acl);
    }
    else if (acl->type == ACLTYPE_DOMAIN) {
      if (!strcmp(acl->from, hostname))
	return(acl);
    }      
    acl = acl->next;
  }
  return(0);
}

void acl_set(aclT *aclA, aclT *aclD)
{
  // Initialze the default ACL
  if (config.aclorder) {
    /* allow, deny */
    if (aclA)
      config.acl->options |= aclA->options;
    if (aclD)
      config.acl->options &= ~aclD->options;
  }
  else {
    /* deny, allow */
    if (aclD)
      config.acl->options &= ~aclD->options; 
    if (aclA)
      config.acl->options |= aclA->options;
  }
}

void acl_init(char *hostname, char *ipaddr)
{
  aclT *aclA, *aclD, *acltmp;

  /* search the ALL-type */
  aclA=findACLbytype(config.allow, ACLTYPE_ALL);
  aclD=findACLbytype(config.deny, ACLTYPE_ALL);
  acl_set(aclA, aclD);

  /* now iterate over all ACL's and find the ones that match most */
  if (!strcmp(hostname, "localhost")) {
    aclA=findACLbytype(config.allow, ACLTYPE_LOCALHOST);
    aclD=findACLbytype(config.deny, ACLTYPE_LOCALHOST);
  }
  else { 
    aclA = findACLbyhost(config.allow, hostname, ipaddr);
    aclD = findACLbyhost(config.deny, hostname, ipaddr);
  }
  acl_set(aclA, aclD);
}
