#ifndef ACL_H
#define ACL_H

typedef struct aclT {
  int type;             /* The type of this ACL */
  char *from;           /* IP or partial domain-name */
  unsigned int options; /* The actual options */
  struct aclT *next;           /* The next ACL-Entry */
} aclT;

#define ACL_IDLETIME  1 /* show idle time */
#define ACL_FROMHOST  2 /* show from host */
#define ACL_MAIL      4 /* show mail status */
#define ACL_USERLIST  8 /* finger @host request */

#define ACLTYPE_ALL       1 /* from all, from==NULL */
#define ACLTYPE_LOCALHOST 2 /* from localhost, from==NULL */
#define ACLTYPE_DOMAIN    3 /* from dom.ain */
#define ACLTYPE_IP        4 /* from w.x.y.z */

/* evaluate connection and acl info */
void acl_init(char *hostname, char *ipaddr); 

#endif /* ACL_H */
