/* PIPServer - A deamon for finger protocol v2
 *
 * Copyright (C) 1999-2001 Michael Baumer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * $Id: compat.c,v 1.5 2001/07/04 08:01:45 baumi Exp $
 */

/* Compatibility library for systems with missing functions */


#include <config.h>      /* for HAVE_* defines */
#include "compat.h"

#ifndef HAVE_STRDUP

#include <stdlib.h>
#include <string.h>

char *strdup(const char *s)
{
  char *dest;
  
  dest = (char *)malloc(strlen(s));

  if (dest)
    strcpy(dest, s);

  return(dest);
}

#endif /* HAVE_STRDUP */

#if !defined(HAVE_INET_NTOA) || defined(BROKEN_INET_NTOA)

#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>

/*
 * Convert network-format internet address
 * to base 256 d.d.d.d representation.
 */

char *inet_ntoa(struct in_addr in)
{
        static char b[18];
        register char *p;

        p = (char *)&in;
#define UC(b)   (((int)b)&0xff)

#ifdef HAVE_SNPRINTF
        (void)snprintf(b, sizeof(b),
#else
        (void)sprintf(b,
#endif
            "%d.%d.%d.%d", UC(p[0]), UC(p[1]), UC(p[2]), UC(p[3]));
        return (b);
}

#endif /* HAVE_INET_NTOA */
