/* PIPServer - A client for finger protocol v2
 *
 * Copyright (C) 1999 Michael Baumer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* Make a connection to a remote host */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>

#include "log.h"
#include "conn.h"

int portnumber = 79;

/* hostname does not keep constant over this call */

int make_conn(char *hostname, char **res_host)
{
  int s;
  struct sockaddr_in rem_addr;
  struct hostent *h_ent;
  
  h_ent = gethostbyname(hostname);
  
  if (!h_ent)
    return -1;
  
  if (res_host)
    *res_host = h_ent->h_name;

  rem_addr.sin_family = AF_INET;
  rem_addr.sin_port = htons(portnumber);
  rem_addr.sin_addr = *((struct in_addr *)h_ent->h_addr);
  
  if ((s = socket(AF_INET, SOCK_STREAM, 0))<0) {
    log(LOG_ERR, "Could not create socket: %m");
    return -1;
  }
  
  if (connect(s, (struct sockaddr *)&rem_addr, sizeof(rem_addr))<0) {
    log(LOG_ERR, "Connect to %s failed: %m", hostname);
    return -1;
  }

  /* Connection established */
  return(s);
}
