/* PIPServer - A deamon for finger protocol v2
 *
 * Copyright (C) 1999 Michael Baumer <baumi@vis.ethz.ch>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* $Id: file.c,v 1.9 2001/07/04 14:37:30 baumi Exp $
 *
 * Handle local files like .plan, .project and .fingerrc
 *
 */

#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

#include "finger.h"
#include "file.h"
#include "log.h"

/* macros and defs that are not always available */

#ifndef S_IROTH 
#define S_IROTH  00004
#endif

#ifndef S_ISREG
#define S_ISREG(mode) (((mode) & S_IFMT) == (S_IFREG))
#endif

/* Stats the file and checks if it exists and if it is a regular file
 * Would it be possible to allow sockets? (For some fancyness?)
 */
int file_check(char *filename)
{
  struct stat sbuf;
  
  /* so far we don't accept symbolic links */
  if (lstat(filename, &sbuf) < 0) {

    /* We do not report permission errors and file not found
     * because the file may be in another of the config directories
     */
    if ((errno!=ENOENT) && (errno!=EACCES)) {
      
      /* a real error occured */
      log(LOG_WARNING, "Could not stat file %s: %m", filename);
    }
    return 0;
  }

  if (S_ISREG(sbuf.st_mode)) {

    /* Have we permission to read the file ? */
    if (sbuf.st_mode & S_IROTH)
      return 1;
    else
      return 0;
  }
  else {
    log(LOG_WARNING, "Warning: %s: not a regular file", filename);
    return 0;
  }
}

/* print a file to stdout with CR/LF terminated lines
 * replace '<' with "&lt;" if opt > 0
 * replace '>' with "&rt;" if opt > 0
 */

void print_file(char *filename, int opt)
{
  FILE *f;
  char buf[1024];
  char *idx, *idx2;
  char *scan;

  /* Lines are CR/LF terminated */
  
  if ((f = fopen(filename, "r")) == NULL) {
    /* a real error occured */
    log(LOG_WARNING, "Could not open file %s: %m", filename);
    return;
  }

  while (fgets(buf, sizeof(buf), f)) {
    scan = buf;
    while (opt && ((idx = strchr(scan, '<')) || (idx2 = strchr(scan, '>')))) {
      if (idx && (!idx2 || (idx2>idx)) ) {
	*idx = '\0';
	fprintf(stdout, "%s&lt;", scan);
	scan = idx + 1;
      }
      else if (idx2) {
	*idx2 = '\0';
	fprintf(stdout, "%s&rt;", scan);
	scan = idx2 + 1;
      }
    }
    if ((idx = strchr(scan, '\n')))
      *idx = '\0';
    fprintf(stdout, "%s\r\n", scan);
  }
  fclose(f);
}

/* find a 'special' file like .plan or .key in the users home
 * and all configured userfilepaths.
 */
char * findUserFile(finger_userinfo *pwd, char *file)
{
  int j;
  static char filename[1024];
  
  sprintf(filename, "%s/.%s", pwd->homedir, file);
  if (file_check(filename)) 
    return filename;

  j = 0;
  while(config.userfilepath[j]) {
    sprintf(filename, "%s/%s/%s", 
	    config.userfilepath[j], pwd->pw_name, file);
    if (file_check(filename))
      return filename;
    j++;
  }
  return NULL;
}
