/* PIPServer - A deamon for finger protocol v2
 *
 * Copyright (C) 1999-2001 Michael Baumer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* The Site Finger Daemon
 * 
 * This program calls the fingerdaemons from all hosts from a site
 * and automatically loggs the users in an out on the main server
 *
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <signal.h>
#ifndef HAVE_SETSID
#include <sys/ioctl.h>
#endif

#include "config.h"

#include "finger.h"
#include "configfile.h"
#include "init.h"
#include "compat.h"
#include "log.h"
#include "poll_clients.h"

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

#ifndef HAVE_GETOPT_DECL
int getopt(int argc, char **argv, char *optstring);
extern char *optarg;
extern int optind;
#endif 

fingerconf config;
int debug = FALSE;

int goaway = FALSE;

void usage(char *progname)
{
  printf("%s Usage: \n%s [-h] [-v] [-V] [-a] [-d]\n", progname);
  printf("\t-c file\tuse \"file\" as configuration file\n"
	 "\t-h\tprint this screen and exit\n"
	 "\t-v\tverbose output\n"
	 "\t-V\tprint version number and exit\n"
	 "\t-d\tdebug modus\n"); 
/*	 "\t-p\t\n\t-L\n\t-l\n\t-w\tno option - accepted for compatibility\n");
 */
}

RETSIGTYPE debugAbort(int num)
{
  goaway = TRUE;
}

int main(int argc, char *argv[])
{
  int flag;
  int verbose = FALSE;
  int detach = TRUE;
  int portnumber = 7979;
  char *progname;
  pid_t pid;

  /* extraxt base name */
  progname = strrchr(argv[0], '/');
  if (!progname)
    progname = argv[0];
  else
    progname++;

  /* parse the command line arguments */

  while ((flag = getopt(argc, argv,
			"acdvVp:"))	 != EOF)

      switch (flag) {
      case 'a':
	detach = FALSE;
	break;
      case 'c':
	configfile = strdup(optarg);
	break;
      case 'd':
	debug = TRUE;
	detach = FALSE;
	signal(SIGUSR1, debugAbort);
	break;
      case 'v':
	verbose = TRUE;
	break;
      case 'V':
	printf("%s: %s Version %s\n", argv[0], PACKAGE, VERSION);
	exit(0);
      case 'p':
	portnumber = atoi(optarg);
	break;
      case 'h':
      default:
	usage(progname);
	exit(0);
      }

  /* read the global fingerconf */
  Init(progname, !detach);
  
  if (!config.numclients) {
    log(LOG_ERR, "No clients specified. Exiting.");
    exit(-1);
  }

  setHandler("online_reply", handle_online_user);

  /* Detach from terminal */
  if (detach) {
    
    if ((pid = fork()) < 0) {
      log(LOG_ERR, "fork() failed: %m");
      exit(-1);
    }
    else if (pid != 0) {
      /* parent process simply should go away */
      exit(0);
    }
    
    /* Child continues */

#ifdef HAVE_SETSID
    setsid();   /* Become session leader */
#else
    ioctl(0, TIOCNOTTY, 0);
#endif
    chdir("/"); /* Change working direcotry */
    umask(0);   /* Clear file creation mask */      
  }

  log(LOG_INFO, "%s site finger deamon started. "
      "Polling interval: %d seconds", PACKAGE, config.interval);

  /* the main loop starts here */
  while (!goaway) {
    
    /* connect to all clients */
    pollClients();
    
    /* sleep for the defined interval */
    sleep(config.interval);
  }
}
