/* PIPServer - A deamon for finger protocol v2
 *
 * Copyright (C) 1999 Michael Baumer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * $Id: flock.c,v 1.1 1999/08/16 09:39:06 baumi Exp $
 */

/* A BSD flock(2) emulation for systems that do not have it */

#include "config.h"

#include "flock.h"

#ifndef HAVE_FLOCK

#include <fcntl.h>
#include <errno.h>

/*
 * Translate flock(2) functions into fcntl(2) calls.
 */
int flock(int fd, int operation)
{
  struct flock lk;
  int ret;

  if (operation & LOCK_SH)
    lk.l_type = F_RDLCK;
  else if (operation & LOCK_EX)
    lk.l_type = F_WRLCK;
  else if (operation & LOCK_UN)
    lk.l_type = F_UNLCK;

  lk.l_whence = 0;
  lk.l_start = 0;
  lk.l_len = 0;

  ret = fcntl(fd, (operation & LOCK_NB) ? F_SETLK : F_SETLKW , &lk);

  if (ret < 0 && (errno == EACCES || errno == EAGAIN))
    errno = EWOULDBLOCK;

  return ret;
}
#endif /* HAVE_FLOCK */
