/* PIPServer - A deamon for finger protocol v2
 *
 * Copyright (C) 1999 Michael Baumer <baumi@vis.ethz.ch>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* Functions for compatibility with the GNU Finger site daemon 
 *
 * This is intended to allow a site to run GNU Finger
 * and the PFinger in parallel. 
 *
 * The same effect could be achieved with the PFinger site daemon
 * but would require all clients to install the PFinger in.fingerd.
 * Using of this compatibility mode allows to succesively install
 * the PFinger in.fingerd.
 */

/* Description:
 *
 * Computes the idle time of a given terinal
 */

#include <config.h>

#include <time.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#define DEVPATH "/dev/"

time_t get_tty_idletime(char *devname)
{
  struct stat status;
  char fname[80];

#ifdef HAVE_SNPRINTF
  snprintf(fname, 79, "%s%s", DEVPATH, devname);
#else
  sprintf(fname, "%s%s", DEVPATH, devname);
#endif
  fname[79] = '\0';

  if (stat(fname,&status) < 0) {
    /* Don't fail
     * Fake activity 
     */
    return ((time_t)0);
  }

  /* return diff current time to last access time */

  return(time(NULL) - status.st_atime);
}
