/* PIPServer - A deamon for finger protocol v2
 *
 * Copyright (C) 1999 Michael Baumer <baumi@vis.ethz.ch>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* $Id: mail.c,v 1.3 1999/08/16 12:22:11 baumi Exp $
 * 
 * Description:
 *
 * Check if mail is read and if mail is forwarded
 * If this information is showed or not is not handled here 
 */

#include <config.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>

#include "finger.h"
#include "mail.h"

#define MAILSPOOL "/var/spool/mail"

int checkmail(finger_userinfo *uinfo, time_t *access_time)
{
  struct stat statinfo;
  char mailfile[80];
  
#ifdef HAVE_SNPRINTF
  snprintf(mailfile, 80, "%s/%s", MAILSPOOL, uinfo->pw_name);
#else
  sprintf(mailfile, "%s/%s", MAILSPOOL, uinfo->pw_name);
#endif
  mailfile[79] = '\0';
  
  if (stat (mailfile, &statinfo) < 0 || statinfo.st_size == 0)
    return(NO_MAIL);
  else {
    if (statinfo.st_atime < statinfo.st_mtime) {
      /* New Mail */

      /* Note: GNU finger also reports the last access time */

      *access_time = statinfo.st_mtime;
      return NEW_MAIL;
    }
    else if (statinfo.st_atime == statinfo.st_mtime) {
      /* Some systems set atime to mtime on mail delivery
       * So we cannot find out when the first new mail arrived 
       */
      *access_time = statinfo.st_mtime;
      return UNREAD_MAIL;
    }
  }

  return READ_MAIL;
}
