/* PIPServer - A deamon for finger protocol v2
 *
 * Copyright (C) 1999 Michael Baumer <baumi@vis.ethz.ch>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef PARSER_H
#define PARSER_H

#define MAX_ID_LEN 64
#define BUFSIZE 2048

typedef struct Node {
  int type;
  struct Node *child, *last, *next, *parent;
  char *value;
  int val_len;
  char id[MAX_ID_LEN];
} Node;

typedef void (*handlefunc)(Node*);

typedef struct node_info {
  char id[MAX_ID_LEN];
  handlefunc func;
} node_info;

int ParseNode(int fd, Node *node);

void setHandler(char *id, handlefunc hfunc);

void FreeParseTree(Node *node);

Node * newNode(int val_len);

#define PIP 0

#define OPTION 10
#define NOOPTION 11

#endif /* PARSER_H */
