/* PIPServer - A deamon for finger protocol v2
 *
 * Copyright (C) 1999-2001 Michael Baumer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* The Site Finger Daemon
 * 
 * This program calls the fingerdaemons from all hosts from a site
 * and automatically loggs the users in an out on the main server
 *
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <time.h>

#include "finger.h"
#include "configfile.h"
#include "conn.h"
#include "statusdb.h"
#include "log.h"
#include "poll_clients.h"

db_entry *firstentry;
db_entry *cur_entry;

extern int debug;

/* handle users that are online */
void handle_online_user(Node *node)
{
  Node *subnode;
  Node *s2node;
  char *login;
  char *realname;
  char *host;
  char *status;
  char *fromhost;
  time_t login_time = 0, idle_time;

  idle_time= 0;

  subnode = node->child;
  while(subnode) {
    login = NULL;
    status = "unknown";
    host = "(unknown)";
    fromhost = "";

    s2node = subnode->child;
    while (s2node) {
      if (!strcmp(s2node->id, "login"))
	login = s2node->value;
      else if (!strcmp(s2node->id, "status")) 
	status = s2node->value;
      else if (!strcmp(s2node->id, "host")) 
	host = s2node->value;
      /*
      else if (!strcmp(s2node->id, "realname"))
	realname = s2node->value;
      */
      else if (!strcmp(s2node->id, "utctime"))
	login_time = atoi(s2node->value);
      else if (!strcmp(s2node->id, "idle"))
	idle_time = atoi(s2node->value);
      else if (!strcmp(s2node->id, "from"))
	fromhost = s2node->value;

      s2node = s2node->next;
    }

    if (debug)
      printf("user %s is %s on %s\n", login, status, host);

    if (login) {
      /* fill in the relevant fields for the db entry */
      strcpy(cur_entry->login_user, login);
      strcpy(cur_entry->status, status);
      strcpy(cur_entry->hostname, host);
      strcpy(cur_entry->fromhost, fromhost);
      if (login_time)
	cur_entry->login_time = login_time;
      else
	cur_entry->login_time = times(NULL);
      cur_entry->idle_time = idle_time;
      
      /* This is freed in statusdb */
      cur_entry->next = (db_entry *)calloc(1, sizeof(db_entry));
      if (!cur_entry->next) {
	/* now we have a problem...
	// we try our luck and simply ignore this entry
	*/
	log(LOG_ERR, "handle_online_user: could not allocate db_entry");
	break;
      }
      cur_entry = cur_entry->next;
      cur_entry->next = NULL;      
    }

    subnode = subnode->next;
  }
}


void pollClients()
{
  int i;
  int s;
  char *cmd = "<localonline></localonline></pip>\n";
  db_entry *prev, *tmp, *tmp2, *prev2, *liststart;

  for (i=0; i<config.numclients; i++) {
    if (debug)
      log(LOG_DEBUG, "Checking client: %s\n", config.clients[i]);

    /* Initialize the list that will be created by this call */
    if (!i) {
      firstentry = (db_entry *)calloc(1, sizeof(db_entry));     
      cur_entry = firstentry;
    }
    else {
      liststart = (db_entry *)calloc(1, sizeof(db_entry));     
      cur_entry = liststart;
    }  
    cur_entry->next = NULL;

    /*
    // If memory allocation failed, try again later
    */
    if (!cur_entry) {
      return;
    }

    /* Send the local_online request
    // and ignore any errors
    */
    s = make_conn(config.clients[i], NULL);
    if (s >= 0) {
      send_request(s, s, cmd);
      close(s);
    }

    /* Merge users that are logged in on multiple hosts */
    if (i) {

      tmp = firstentry;
 
      while(tmp->next) {

	tmp2 = liststart;
	prev2 = NULL;

	while(tmp2->next) {
	  if (!strcmp(tmp->login_user, tmp2->login_user)) {
	    /* the remote host(s) may not report the idle time */
	    if ((!tmp2->idle_time) && (!tmp->idle_time)) {

	      /* take the second entry only if it is active */
	      if ((!strcmp(tmp2->status, "active")) &&
		  (strcmp(tmp->status, "active"))) {

		tmp->idle_time = tmp2->idle_time;
		tmp->login_time = tmp2->login_time;
		strcpy(tmp->status, tmp2->status);
		strcpy(tmp->hostname, tmp2->hostname);
	      }
	    }
	    /* ... if they do, take entry with smaller idle time */
	    else if (tmp2->idle_time < tmp->idle_time) {
	      tmp->idle_time = tmp2->idle_time;
	      tmp->login_time = tmp2->login_time;
	      strcpy(tmp->status, tmp2->status);
	      strcpy(tmp->hostname, tmp2->hostname);
	    }
	    /* Free the second entry */
	    if (!prev2) {
	      liststart = liststart->next;
	      free(tmp2);
	      tmp2 = liststart;
	    }
	    else {
	      tmp2 = tmp2->next;
	      free(prev2->next);
	      prev2->next = tmp2;
	    }
	  }
	  else
	    tmp2 = tmp2->next;
	}
	tmp = tmp->next;
      }
      
      /* concatenate the two lists */
      tmp = firstentry;
      if (!tmp->next) {
	/* first list is empty - replace it */
	free(firstentry);
	firstentry = liststart;
      }
      else {
	while(tmp->next->next) 
	  tmp = tmp->next;
	/* now we are on the last valid entry */
	free(tmp->next);
	tmp->next = liststart;
      }
    }
  }

  db_insertlist(firstentry);

  /* free memory */
  cur_entry = firstentry;
  while(cur_entry) {
    tmp = cur_entry->next;
    free(cur_entry);
    cur_entry = tmp;
  }
}
