/* PIPServer - A deamon for finger protocol v2
 *
 * Copyright (C) 1999 Michael Baumer <baumi@vis.ethz.ch>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* $Id: utmplib.c,v 1.4 2001/06/24 15:10:14 baumi Exp $
 *
 * Description:
 *
 * Provides the utmp access routines (setutent, getutent, endutent) for
 * systems that do not have them (e.g. NetBSD 1.3).
 * If the system provides these function don't get compiled in the 
 * binary.
 */

#include <config.h>

#if !defined(HAVE_SETUTENT) && !defined (HAVE_UTMPX_H)

#include <time.h> /* Don't ask... */
#include <utmp.h>
#include <fcntl.h>
#include <stdio.h> /* for NULL ;-) */
#ifdef HAVE_PATHS_H
#include <paths.h>
#endif

#ifndef _PATH_UTMP
#warning _PATH_UTMP not declared: We use /etc/utmp
#define _PATH_UTMP "/etc/utmp"
#endif

#include "log.h"

static int utmp_fd;
static int utmp_open;

void setutent(void)
{
  if (utmp_open)
    close(utmp_fd);

  if ((utmp_fd = open(_PATH_UTMP, O_RDONLY)) < 0) {
    log(LOG_ERR, "Could not open %s: %m", _PATH_UTMP);
    utmp_open = 0;
  }
  else 
    utmp_open = 1;
}

void endutent(void)
{
  if (utmp_open)
    close(utmp_fd);
}

struct utmp *getutent(void)
{
  static struct utmp _utmpent;
  int res;

  res = read(utmp_fd, &_utmpent, sizeof(struct utmp));
  if (res<0)
    log(LOG_ERR, "Could not read from %s: %m", _PATH_UTMP);

  else 
    if (!res)
      return (struct utmp*)NULL;

  return &_utmpent;
}

#endif /* !defined(HAVE_SETUTENT) && !defined (HAVE_UTMPX_H) */
