/* Test-Suite for pfinger
 *
 * Copyright (C) 2001 Michael Baumer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>

#include "statusdb.h"
#include "log.h"
#include "finger.h"

fingerconf config;

#define NUM_USER 256

char users[NUM_USER][5];

/* local_online.c emulation */
finger_userinfo finfo = 
{
  "TEST ",
  "TEST ",
  "TEST ",
  "TEST ",
  "TEST ",
  "TEST "
};

finger_userinfo * pwd_search_login(char *username)
{
  finfo.pw_name = username;
  return &finfo;
}

finger_userinfo  * pwd_search_realname(char *username)
{
  return &finfo;
}

void create_logins()
{
  int i, j;

  char login[5];

  strcpy(login, "aaaa");

  for (i=0; i<NUM_USER; i++) {
    strcpy(users[i], login);
    login[3]++;
    if (login[3] == 'z') {
      login[2]++;
      login[3] = 'a';
      if (login[2] == '}') {
	login[1]++;
	login[2] = 'a';
	if (login[1] == '}') {
	  login[0]++;
	  login[1] = 'a';
	  if (login[0] == '}') {
	    fprintf(stderr, "NUM_USER is too high. Stopping at %d", i);
	    exit(-1);
	  }
	}
      }
    }
  }
}

db_entry * create_list()
{
  db_entry *first, *cur;
  int i;

  first = (db_entry *)malloc(sizeof(struct db_entry));  
  if (!first) {
    log(LOG_ERR, "Could not allocate memory: %m");
    exit(-1);
  }
  memset(first, 0, sizeof(struct db_entry));
  cur = first;

  for (i=0; i<NUM_USER; i++) {
    strcpy(cur->login_user, users[i]);
    strcpy(cur->realname, "TEST-LOGIN");
    strcpy(cur->hostname, "TEST-HOST");
    strcpy(cur->fromhost, "TEST-FROMHOST");
    strcpy(cur->status, "TEST-unknown");
    cur->next = (db_entry *)malloc(sizeof(struct db_entry));
    if (!cur->next) {
      log(LOG_ERR, "Could not allocate memory (i=%d): %m", i);
      exit(-1);
    }
    memset(cur->next, 0, sizeof(struct db_entry));
    cur = cur->next;
  }

  return first;
}

int main()
{
  int dbfd;
  db_entry *list;
  struct stat s_buf;

  log_open("db_test", LOGTYPE_STDERR);

  if ((dbfd = open("/tmp/statusdb", (O_CREAT), (S_IREAD | S_IWRITE))<0)) {
    log(LOG_ERR, "could not create status DB file: %m");
    return -1;
  }
  close(dbfd);
 
  /* test file in /tmp */
  config.dbpath = "/tmp";
  
  /* empty list */
  db_insertlist(0);

  create_logins();

  list = create_list();
  db_insertlist(list);

  /* size of db correct? */
  stat("/tmp/statusdb", &s_buf);
  if (s_buf.st_size != NUM_USER*sizeof(struct db_entry)) {
    log(LOG_ERR, "Size of file is to small: %d instead of %d",
	s_buf.st_size, NUM_USER*sizeof(struct db_entry));
  }
  
  /* clean up */
  /*  unlink("/tmp/statusdb"); */

  return 0;
}
