/* Test-Suite for pfinger
 *
 * Copyright (C) 2001 Michael Baumer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>

#include "statusdb.h"
#include "log.h"
#include "finger.h"
#include "compat.h"
#include "parser.h"

#define NUM_CLIENTS 256
#define NUM_USER 128

char users[NUM_USER][5];
int user_idle[NUM_USER];
int user_host[NUM_USER];
int user_login_t[NUM_USER];

int cur_host;

Node mynode;

fingerconf config;
int debug;

int db_insertlist(db_entry *list)
{
  int i;
  int j;

  i = 0;
  while(list->next) {

    /* Iterate over list and compare with saved values */

    for (j=0; j<NUM_USER; j++)
      if (!strcmp(list->login_user, users[j]))
	break;

    if (j==NUM_USER)
      log(LOG_ERR, "User %d not found in users[]", list->login_user);
    else {
      /* Compare */
      if (list->idle_time != user_idle[j])
	log(LOG_ERR, "Idle times do not match: %d vs. %d (user: %s)", list->idle_time, user_idle[j], list->login_user);
      
      if (strcmp(list->hostname, config.clients[user_host[j]]))
	log(LOG_ERR, "Hosts do not match: %s vs. %s (user: %s)", list->hostname, config.clients[user_host[j]], list->login_user);

      if (list->login_time != user_login_t[j])
	log(LOG_ERR, "login times do not match: %d vs. %d (user: %s)", list->login_time, user_login_t[j], list->login_user);

    }

    list = list->next;
    i++;
  }

  if (i<NUM_USER)
    log(LOG_ERR, "too few users in list");

  return 1;
}

/* called by pollClients()
 *
 * create some socket that will be closed by
 * pollClients()
 */
int make_conn(char *hostname, char **res_host)
{
  int s;
  int i;
  
  s = open("/tmp/statusdb", O_RDONLY);

  cur_host++;
  if (!cur_host)
    for (i=0; i<NUM_USER; i++)
      user_idle[i] = 1000;

  return s;
}

/* called by pollClients
 *
 * it should fill the list of users logged in
 * (i.e. call handle_online_user)
 */
int send_request(int fdin, int fdout, char *cmd)
{
  int i;
  int idle;
  int login_t;

  /* for now we emulate, that all users are logged in on
     all hosts with random idle times
  */
  
  for (i=0; i<NUM_USER; i++) {
    /* login name */
    strcpy(mynode.child->child->value, users[i]);
    /* idle time */
    idle = rand() % 1000;
    sprintf(mynode.child->child->next->value, "%d", idle);
    /* login time */
    login_t = time(NULL)-(rand() % 10000);
    sprintf(mynode.child->child->next->next->value, "%d", login_t);
    /* host name */
    sprintf(mynode.child->child->next->next->next->value, "%s", config.clients[cur_host]);

    /* save values for most active user/host for later check */
    if (user_idle[i] > idle) {
      user_idle[i] = idle;
      user_login_t[i] = login_t;
      user_host[i] = cur_host;
    }

    handle_online_user(&mynode);
  }
  return 1;
}

void create_logins()
{
  int i, j;

  char login[5];

  strcpy(login, "aaaa");

  for (i=0; i<NUM_USER; i++) {
    strcpy(users[i], login);
    login[3]++;
    if (login[3] == 'z') {
      login[2]++;
      login[3] = 'a';
      if (login[2] == '}') {
	login[1]++;
	login[2] = 'a';
	if (login[1] == '}') {
	  login[0]++;
	  login[1] = 'a';
	  if (login[0] == '}') {
	    fprintf(stderr, "NUM_USER is too high. Stopping at %d", i);
	    exit(-1);
	  }
	}
      }
    }
  }
}

/* create a node for handle_online_user
 *
 * online_reply -> user -> login
 *                         utctime
 *                         ...
 */
void create_node()
{
  Node *node;

  /* top node */
  strcpy(mynode.id, "online_reply");
  mynode.child = (Node *)calloc(1, (sizeof(Node)));
  node = mynode.child;

  /* user node */
  strcpy(node->id, "user");
  node->child = (Node *)calloc(1, (sizeof(Node)));
  node = node->child;

  /* field nodes */
  /* the first one is the login name */
  strcpy(node->id, "login");
  node->value = (char *)calloc(1, 256);
  node->next = (Node *)calloc(1, (sizeof(Node)));
  node = node->next;

  /* the second is the idle time */
  strcpy(node->id, "idle");
  node->value = (char *)calloc(1, 256);
  node->next = (Node *)calloc(1, (sizeof(Node)));
  node = node->next;

  /* the third is the login time */
  strcpy(node->id, "utctime");
  node->value = (char *)calloc(1, 256);
  node->next = (Node *)calloc(1, (sizeof(Node)));
  node = node->next;

  /* the 4th is the host name */
  strcpy(node->id, "host");
  node->value = (char *)calloc(1, 256);

}

void init_clients()
{
  char host[5];
  int i;

  config.clients = (char **)malloc(NUM_CLIENTS*sizeof(void *));
    
  strcpy(host, "aaaa");
    
  for (i=0; i<NUM_CLIENTS; i++) {
    config.clients[i] = strdup(host);
    host[3]++;
    if (host[3] == 'z') {
      host[2]++;
      host[3] = 'a';
      if (host[2] == '}') {
	host[1]++;
	host[2] = 'a';
	if (host[1] == '}') {
	  host[0]++;
	  host[1] = 'a';
	  if (host[0] == '}') {
	    fprintf(stderr, "NUM_CLIENTS is too high. Stopping at %d", i);
	    exit(-1);
	  }
	}
      }
    }
  }
  config.numclients = NUM_CLIENTS;
}

int main()
{	  
  int j;

  debug = 0;
  log_open("poll_test", LOGTYPE_STDERR);
  init_clients();
  create_logins();
  create_node();

  for (j=0; j<10; j++)
    {
      log(LOG_DEBUG, "run %d", j);
      cur_host = -1;
      pollClients();
    }

  return 0;
}
