/* 
pGina PAM Server - A PAM-Aware Unix Daemon for pGina
Copyright (C) 2003 Nathan Yocom, Jiho Kim

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: nate.yocom@xpasystems.com
Email: jiho.kim@xpasystems.com
Web: http://pgina.xpasystems.com
Snail Mail:
  Nathan Yocom 
  9 Evergreen Farms Rd.
  Scarborough, ME 04074
  Phone: 207-450-4948
*/
/* 	
	$Log: access.h,v $
	Revision 1.1  2003/08/06 04:58:33  nyocom
	Initial Import
	
	Revision 1.7  2003/05/16 01:52:18  jkim
	-with-authasst-group option added
	header dependency problem in compilation fixed in pgina_pam_misc.h
	importing authasst.groups config file
	
	Revision 1.6  2003/05/01 02:40:27  xpasys
	Changed authasst to work with IP/FQDN/hostname.
	Imported source of Jiho's client into CVS
	
	Revision 1.5  2003/04/30 00:16:38  xpasys
	Added GPL to jiho's code
	Added --enable-debug notes to README and upgrade info
	
	Revision 1.4  2003/04/29 16:53:43  xpasys
	Several solaris compilation fixes added
	
 	Revision 1.3  2003/04/29 16:46:31  xpasys
	Added install target for authasst.conf files
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <ctype.h>

#include "linkedlist.h"

//Don't changes these!  They're indices to an array in 
#define DENY 0
#define ALLOW 1
#define UNDEFINED 2

#define DELIMS " ,\t\n"

#define NUM_LINE_LIMIT 100000


//structs

typedef struct groupdef {
  int num;
  char** groups;
  LL** members;  
} groupdef;



typedef struct rule {
  char* usergroup;
  char* hostgroup;
} rule;



typedef struct ruledef {
  int num;
  rule** rules;
} ruledef;


 
//file names
char * allowfile;
char * denyfile;
char * userfile;
char * hostfile;
char * groupfile;


//global vars
groupdef * users_defs;
groupdef * hosts_defs;
ruledef * allow_defs;
ruledef * deny_defs;
groupdef * groups;
LL* dns_suffixes;

//debug
void debug_config();


//helper function.  trims whitespace off strings.
char* trim(char *);


void free_groupdef(groupdef *);
void free_ruledef(ruledef* rd);


//clean up config variables
void cleanup_config();

// returns ALLOW for good username/host pair, DENY otherwise.
int authorized(const char * username, const char * host);

//reads config filse.
int init_access();


rule* checkrules(ruledef *, const char *, const char *);
int check_pair(const char*, const char *);

//get fully qualified domain name (given an IP address string)
char* get_fqdn(const char*);

LL* parseConfigFile(const char*);
groupdef* read_group_config_file(const char*);
ruledef* read_rule_config_file(const char*);
groupdef* read_group_file(const char*);



