#include <stdio.h>
#include <stdlib.h>
#include <openssl/ssl.h>
#include "ssl_agent.h"



int main(int argc, char *argv[])
{
  SSL *ssl;
  SSL_CTX *ctx;
  BIO *conn;
  char *message_from_server;
  int i;
  
  // Init OpenSSL
  OpenSSL_add_all_algorithms();
  SSL_load_error_strings();
  
  // Init context
  ctx = SSL_CTX_new(TLSv1_method());
  if(!ctx) {
      // Error creating context
      
      fprintf(stderr, "Error creating context\n");
      exit(1);
  }
  
  // Init SSL
  ssl = SSL_new(ctx);
  if(!ssl) {
      // Error creating SSL.
      fprintf(stderr, "Error creating SSL\n");
      exit(2);
  }
  
  conn = BIO_new_connect(argv[1]);
  
  if(!conn) {
      // Error in BIO_new_connect
      fprintf(stderr, "Error in BIO_new_connect\n");
      exit(3);
  }
  
  if(BIO_do_connect(conn) <= 0) {
      // Error in BIO_do_connect
      fprintf(stderr, "Error in BIO_do_connect\n");
      exit(4);
  }
  
  SSL_set_bio(ssl,conn,conn);
  
  if(SSL_connect(ssl) <= 0) {
      // Error in SSL handshake.
      fprintf(stderr, "Error in SSL handshake\n");
      exit(5);
  }
  
  // we can now communicate with ssl
  // send a string
  
  for (i=2; argv[i]; i++) {
      send_string(ssl,argv[i]);
      printf("%s\n", argv[i]);
  }
  
  
  //read message from server
  message_from_server = read_string(ssl);
  printf("Server responded: %s\n",message_from_server);

  return 0;
}

