/*
pGina PAM Server - A PAM-Aware Unix Daemon for pGina
Copyright (C) 2003 Nathan Yocom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: nate.yocom@xpasystems.com
Web: http://pgina.xpasystems.com
Snail Mail:
  Nathan Yocom 
  9 Evergreen Farms Rd.
  Scarborough, ME 04074
  Phone: 207-450-4948
*/
/*
	$Log: common_ssl.h,v $
	Revision 1.1  2003/08/06 04:58:34  nyocom
	Initial Import
	
	Revision 1.1.1.1  2003/03/22 06:02:20  xpasys
	Imported sources
	
*/

#ifndef COMMON_SSL
#define COMMON_SSL

#include <pthread.h>

#define MUTEX_TYPE          pthread_mutex_t
#define MUTEX_SETUP(x)      pthread_mutex_init(&(x),NULL)
#define MUTEX_CLEANUP(x)    pthread_mutex_destroy(&(x))
#define MUTEX_LOCK(x)       pthread_mutex_lock(&(x))
#define MUTEX_UNLOCK(x)     pthread_mutex_unlock(&(x))
#define THREAD_ID           pthread_self()
#define THREAD_TYPE 		pthread_t
#define	THREAD_CREATE(tid, entry, arg)	pthread_create(&(tid),NULL,(entry),(arg))

static MUTEX_TYPE *mutex_buf;

struct CRYPTO_dynlock_value {
    MUTEX_TYPE mutex;
};

// static mutexes
static void locking_function(int, int, const char *, int);
static unsigned long id_function(void);
int THREAD_setup(void);
int THREAD_clean(void);

// dyn mutexes
static struct CRYPTO_dynlock_value *dyn_create_function(const char *, int);
static void dyn_lock_function(int, struct CRYPTO_dynlock_value *, const char *, int);
static void dyn_destroy_function(struct CRYPTO_dynlock_value *, const char *, int);

#endif
