/* 
pGina PAM Server - A PAM-Aware Unix Daemon for pGina
Copyright (C) 2003 Nathan Yocom, Jiho Kim

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: nate.yocom@xpasystems.com
Email: jiho.kim@xpasystems.com
Web: http://pgina.xpasystems.com
Snail Mail:
  Nathan Yocom 
  9 Evergreen Farms Rd.
  Scarborough, ME 04074
  Phone: 207-450-4948
*/
/* 
	$Log: linkedlist.c,v $
	Revision 1.1  2003/08/06 04:58:34  nyocom
	Initial Import
	
	Revision 1.6  2003/05/01 02:40:27  xpasys
	Changed authasst to work with IP/FQDN/hostname.
	Imported source of Jiho's client into CVS
	
	Revision 1.5  2003/04/30 00:16:38  xpasys
	Added GPL to jiho's code
	Added --enable-debug notes to README and upgrade info
	
	Revision 1.4  2003/04/29 16:53:43  xpasys
	Several solaris compilation fixes added
	
	Revision 1.3  2003/04/29 16:46:31  xpasys
	Added install target for authasst.conf files
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "linkedlist.h"

LL* freenode(LLnode * node)
{
    if (node) 
    {	
	if (node->pl)
	    free(node->pl);

	if (node)
	    free(node);
    }

    return NULL;
}

//collects everything
LL* freelist(LL * list)
{
    LLnode * walker;
    LLnode * next;
  
    if (list) 
    {
	walker = list->head;

	while (walker!=NULL) 
	{
	    next = walker->next;
	    freenode(walker);
	    walker = next;
	}

	free(list);
    }

    return NULL;
}

//doesn't kill the content of nodes
LL* free_LL(LL * list)
{
    LLnode * walker;
    LLnode * next;
  
    if (list) 
    {
	walker = list->head;

	while (walker!=NULL) 
	{
	    next = walker->next;
	    free(walker);
	    walker = next;
	}

	free(list);
    }

    return NULL;
}


LL * new_LL()
{
    LL * list = malloc(sizeof(LL));

    list->head=NULL;
    list->tail=NULL;

    return list;
}



int sizeOfLL(LL* list)
{
    LLnode* walker;
    int size=-1;

    if (list!=NULL) 
    {
	size=0;
	for (walker=list->head; walker!=NULL; walker=walker->next) 
	    size++;
    }

    return size;
}

void printLL(const LL* list)
{
    LLnode* walker;

    if (list==NULL) 
    {
	printf("(null)\n");
    }
    else {
	printf("[");
	for (walker=list->head; walker!=NULL; walker=walker->next) 
	{
	    printf("%s", (char *) (walker->pl));
	    if (walker->next!=NULL)
		printf(", ");
	}
	printf("]\n");
    }
}

void add_void_to_LL(LL* list, void* r)
{
    LLnode * nextNode;
  
    if (r==NULL)
	return;

    nextNode = malloc(sizeof(LLnode));

    nextNode->pl = r;
    nextNode->next = NULL;

    if (list->head==NULL) 
    {
	list->head=nextNode;
	list->tail=nextNode;
    }
    else 
    {
	(list->tail)->next=nextNode;
	list->tail=nextNode;
    }
  
    return;

}

void addtoLL(LL* list, const char * str)
{
    add_void_to_LL(list, (void *) strdup(str));
}

void remove_head(LL * list)
{
    LLnode * head = list->head;

    list->head = head->next;
    freenode(head);


    if (list->head==NULL)
	list->tail=NULL;
}

//dont' call this with str=NULL
int isInList(LL* list, const char * str)
{
    LLnode * walker;


    if (list==NULL)
	return 0;

    //consider what happens if strings are NULL.
    for (walker=list->head; walker!=NULL; walker=walker->next) 
    {
	if (!strcmp((char *) (walker->pl), str))
	    return 1;
    }

    return 0;  
}
//dont' call this with str=NULL
int isInList_case(LL* list, const char * str)
{
    LLnode * walker;


    if (list==NULL)
	return 0;

    //consider what happens if strings are NULL.
    for (walker=list->head; walker!=NULL; walker=walker->next) 
    {
	if (!strcasecmp((char *) (walker->pl), str))
	    return 1;
    }

    return 0;  
}

int bubble(LLnode* n0)
{
    int bubbled=0;
    LLnode * n1 = n0->next;
    char * temp;

    if (n1==NULL)
	return 0;

    do 
    {
	temp=NULL;
	if (strcmp(n0->pl, n1->pl)>0) 
	{
	    temp = n0->pl;
	    n0->pl = n1->pl;
	    n1->pl = temp;
	    bubbled = 1;
	}
    
	n0 = n1;
	n1 = n1->next;
    } while (temp!=NULL && n1!=NULL);

    return bubbled;
}


void sortLL(LL * list)
{
    LLnode * walker = list->head;

    while (walker!=NULL) 
    {
	if (bubble(walker)==0)
	    walker = walker->next;
	else
	    walker=list->head;
    }
}


  
  


LL * get_tokens(const char * str, const char * delims)
{
    LL* tokenLL;
    char * token;
    char *temp;
    

    if (str==NULL)
	return NULL;

    tokenLL = new_LL();  
    token=strtok(temp=strdup(str), delims);
  
    while (token!=NULL) 
    {
	addtoLL(tokenLL, token);
	token=strtok(NULL, delims);
    }  

    free(temp);
  
    return tokenLL;
}

LL * get_unique_tokens(const char * str, const char * delims)
{
    LL* tokenLL;
    char * token;
    char * temp;

    if (str==NULL)
	return NULL;

    tokenLL = new_LL();
    temp = strdup(str);
  
    token=strtok(temp, delims);
  
    while (token!=NULL) 
    {
	if (! isInList(tokenLL, token)) 
	    addtoLL(tokenLL, token);
    
	token=strtok(NULL, delims);
    }  
  
    free(temp);

    return tokenLL;
}

void munge(LL* dest, const LL* src)
{
    LLnode* walker;

    if (src==NULL)
	return;

    for (walker=src->head; walker!=NULL; walker=walker->next) 
    {  
	if (! isInList(dest, (char*) walker->pl))
	    addtoLL(dest, (char*) walker->pl);
    }
}

void debug_LL(LL * list) 
{
    LLnode* walker;

    for (walker=list->head; walker!=NULL; walker=walker->next) 
    {
	printf("%s ",(char*)  walker->pl);
    }
    printf("\n");

}
