/* 
pGina PAM Server - A PAM-Aware Unix Daemon for pGina
Copyright (C) 2003 Nathan Yocom, Jiho Kim

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: nate.yocom@xpasystems.com
Email: jiho.kim@xpasystems.com
Web: http://pgina.xpasystems.com
Snail Mail:
  Nathan Yocom 
  9 Evergreen Farms Rd.
  Scarborough, ME 04074
  Phone: 207-450-4948
*/
/* 
	$Log: linkedlist.h,v $
	Revision 1.1  2003/08/06 04:58:34  nyocom
	Initial Import
	
	Revision 1.6  2003/05/01 02:40:27  xpasys
	Changed authasst to work with IP/FQDN/hostname.
	Imported source of Jiho's client into CVS
	
	Revision 1.5  2003/04/30 00:16:38  xpasys
	Added GPL to jiho's code
	Added --enable-debug notes to README and upgrade info
	
	Revision 1.4  2003/04/29 16:53:43  xpasys
	Several solaris compilation fixes added
	
	Revision 1.3  2003/04/29 16:46:31  xpasys
	Added install target for authasst.conf files
*/

#ifndef LINKEDLIST_H
#define LINKEDLIST_H 1

//Linked list structure;
typedef struct LLnode {
  struct LLnode * next;
  void * pl;
} LLnode;

typedef struct LL {
  LLnode *head;
  LLnode *tail;
} LL;

LL* freenode(LLnode * node);
LL* freelist(LL * ); //kill node payload
LL* free_LL(LL * ); //doesn't touch node payload
LL * new_LL();
int sizeOfLL(LL* );
void printLL(const LL* );
void add_void_to_LL(LL* , void *);
void addtoLL(LL* , const char *);
void remove_head(LL * );
int isInList(LL*, const char *);
int isInList_case(LL*, const char *);

void sortLL(LL*);


LL* get_tokens(const char *, const char*);
LL* get_unique_tokens(const char *, const char*);
void munge(LL*, const LL*);

void debug_LL(LL*);




#endif
