#!/usr/bin/perl

$openssl_loc = "/usr/bin/openssl";

print "In order to run the pGina PAM daemon, you need to generate an OpenSSL certificate. I am your friendly perl script here to help you do just that.  Please read the following prompts carefully!\n\n";

print "Location of your OpenSSL binary [/usr/bin/openssl]?: ";

$my_loc = <>;
chomp($my_loc);

if($my_loc ne "")
{
   $openssl_loc = $my_loc;
}

# make our working directory
qx{mkdir certs};
chdir("certs");

print "\nI am now going to setup a root CA, you will be prompted for a passcode (you must provide one) and information regarding your company etc.  Feel free to provide whatever information you want, just do NOT set a challenge password unless you want to be asked for this everytime your server is run and connected.\n";
qx{$openssl_loc req -newkey rsa:2048 -sha1 -keyout root_key.pem -out root_request.pem};
print "\n\nNow I will create a root cert, when prompted, give the pass phrase you gave in the last step.\n";
qx{$openssl_loc x509 -req -in root_request.pem -sha1 -extensions v3_ca -signkey root_key.pem -out root_certificate.pem};
qx{cat root_certificate.pem root_key.pem > root.pem};
print "\nTime for a CA cert, same goes as before, we recommend using the SAME passphrase as previously to avoid confusion";
qx{$openssl_loc req -newkey rsa:2048 -sha1 -keyout CA_key.pem -out CA_request.pem};
print "\n\nNow for the second part, provide the pass you gave last step when prompted\n";
qx{$openssl_loc x509 -req -in CA_request.pem -sha1 -extensions v3_ca -CA root.pem -CAkey root.pem -CAcreateserial -out CAcert.pem};
qx{cat CAcert.pem CA_key.pem root_certificate > CA.pem};
print "\n\nNow we can actually create the cert for your daemon. One moment while we generate a key\n";
qx{$openssl_loc genrsa 2048 > server_key.pem};
print "\nOne more time through the drill as before.";
qx{$openssl_loc req -new -key server_key.pem -sha1 -out server_request.pem};
qx{$openssl_loc x509 -req -in server_request.pem -sha1 -extensions usr_cert -CA CA.pem -CAkey CA.pem -CAcreateserial -out server_certificate.pem};
qx{cat server_certificate.pem server_key.pem CAcert.pem root_certificate > cert.pem};
qx{cat cert.pem > /etc/pgina_pam/cert.pem};
print "\n\nYour certificate has been generated and stored in /etc/pgina_pam/cert.pem.  This completes the installation of the pGina PAM daemon.\n";
