#include <stdio.h>
#include <stdlib.h>
#include <openssl/ssl.h>
#include <openssl/rand.h> 
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/time.h>

#define AUTH_ACTION "AUTH"
#define SUCCESS "SUCC"
#define ERROR "ERR"
#define CHANGE_PASS "CHPS"
#define GET_GROUP "GGRP"
#define DONE "!"

#include <ncurses.h>

void send_string(SSL *mySSL, char *message);
char * read_string(SSL *mySSL);

int main(int argc, char *argv[])
{
	SSL *ssl;
	SSL_CTX *ctx;
	BIO *conn;
	int i;
	char *test = NULL;
	
	// Init OpenSSL
	OpenSSL_add_all_algorithms();
	SSL_load_error_strings();

	ctx = SSL_CTX_new(TLSv1_method());
	if(!ctx)
	{
		// Error creating context
		printf("Problem creating CTX. Aborting.\n");
		exit(-1);
	}

	// Init SSL
	ssl = SSL_new(ctx);
	if(!ssl)
	{
		// Error creating SSL.
		printf("Problem creating SSL Aborting.\n");
		exit(-1);
	}

	conn = BIO_new_connect(argv[1]);

	if(!conn)
	{
		// Error in BIO_new_connect
		printf("Error in BIO_new_connect.\n");
		exit(-1);
	}

	if(BIO_do_connect(conn) <= 0)
	{
		// Error in BIO_do_connect
		printf("Error in BIO_do_connect\n");
		exit(-1);
	}

	SSL_set_bio(ssl,conn,conn);

	if(SSL_connect(ssl) <= 0)
	{
		// Error in SSL handshake.
		printf("Error in SSL handshake.\n");
		exit(-1);
	}

	send_string(ssl,AUTH_ACTION);
	test = read_string(ssl);

}


/* why does this function send bytes one byte at a time? */
void send_string(SSL *mySSL, char *message)
{

	int error = 0, wrote = 0;

	for(wrote = 0; wrote <= strlen(message); wrote++)
	{
		error = SSL_write(mySSL,&message[wrote],1);

		if(error <= 0)
			break;
	}

	return;
}

char * read_string(SSL *mySSL)
{
	char buffer[1024];
	char *ret;
	char this_one;
	int error = 0, read_in = 0;

	memset(buffer,'\0',sizeof(buffer));

	for(read_in = 0; read_in < sizeof(buffer); read_in += error)
	{
		error = SSL_read(mySSL,&this_one,1);

		if(error>0)
			buffer[read_in] = this_one;

		if(error <= 0 || this_one == '\0' || this_one == '\n')
			break;
	}

	if(error <= 0)
		return NULL;

	// Buffer is good here
	ret = (char *) malloc(strlen(buffer) + 1);
	strcpy(ret,buffer);

	return ret;
}
