
#include <stdio.h>
#include <stdlib.h>
#include <string.h> // for memset

// SSL Includes
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/rand.h>




/* why does this function send bytes one byte at a time? */
void send_string(SSL *mySSL, const char *message)
{
    
  int error = 0, wrote = 0;
  int len = strlen(message);
  
  for(wrote = 0; wrote <= len; wrote++) {
    error = SSL_write(mySSL,&message[wrote],1);
    
    if(error <= 0)
      break;
  }
    
  return;
}

char * read_string(SSL *mySSL)
{
	char buffer[1024];
	char *ret;
	char this_one;
	int error = 0, read_in = 0;

	memset(buffer,'\0',sizeof(buffer));

	for(read_in = 0; read_in < sizeof(buffer); read_in += error)
	{
		error = SSL_read(mySSL,&this_one,1);

		if (error>0)
		  buffer[read_in] = this_one;

		if(error <= 0 || this_one == '\0' || this_one == '\n')
			break;
	}

	if(error <= 0)
	  return NULL;

	// Buffer is good here
	ret = (char *) malloc(strlen(buffer) + 1);
	strcpy(ret,buffer);

	return ret;
}

