/*
pGina PAM Server - A PAM-Aware Unix Daemon for pGina
Copyright (C) 2003 Nathan Yocom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: nate.yocom@xpasystems.com
Web: http://pgina.xpasystems.com
Snail Mail:
  Nathan Yocom 
  9 Evergreen Farms Rd.
  Scarborough, ME 04074
  Phone: 207-450-4948
*/
/*
	$Log: pam_convs.c,v $
	Revision 1.1  2003/08/06 04:58:35  nyocom
	Initial Import
	
	Revision 1.5  2003/05/07 21:49:16  jkim
	Reorganized some header dependencies
	Moved some misc function to pgina_pam_misc.c
	Changed syslog to debug_out in authasst code
	Reformatted usage info to fit in 80 cols.
	
	Revision 1.4  2003/04/17 03:59:00  xpasys
	Memory audit completed, found 1 leak - patched.
	
	Revision 1.3  2003/04/11 04:50:26  xpasys
	Refitted mutexing to allow for better performance, possible solve
	deadlock issues
	Added debug trace info
	
	Revision 1.2  2003/04/07 17:18:26  xpasys
	Changed line endings to Unix
	Added code to be a bit friendlier on bad arguments (thanks to Jiho Kim)
	
	Revision 1.1.1.1  2003/03/22 06:02:20  xpasys
	Imported sources
	
*/

#include "pgina_pam_server.h"
#include "actions.h"

#ifndef SOLARIS
/** PAM Conversation for user authentication */
int auth_conv(int num_msg,const struct pam_message **msg, struct pam_response **response, void *appdata_ptr)
#else
int auth_conv(int num_msg, struct pam_message **msg, struct pam_response **response, void *appdata_ptr)
#endif
{
	struct pam_response *reply_with = NULL; 
	int num_replies; 
	struct auth_struct *user_data;
	user_data = (struct auth_struct *) appdata_ptr;
	
	if( num_msg <= 0 )
		return PAM_CONV_ERR;

	reply_with = (struct pam_response *)calloc(num_msg, sizeof(struct pam_response)); 

	if( reply_with == NULL )
		return PAM_SYSTEM_ERR;
	
	for( num_replies = 0; num_replies < num_msg; num_replies++ )
	{
		if( msg[num_replies]->msg_style == PAM_PROMPT_ECHO_OFF )
		{
			reply_with[num_replies].resp_retcode = PAM_SUCCESS; 
//			reply_with[num_replies].resp = strdup(gl_password); 
			reply_with[num_replies].resp = strdup(user_data->password);
		}
		else if( msg[num_replies]->msg_style == PAM_PROMPT_ECHO_ON )
		{
			reply_with[num_replies].resp_retcode = PAM_SUCCESS; 
//			reply_with[num_replies].resp = strdup(gl_username); 
			reply_with[num_replies].resp = strdup(user_data->username);

		}
		else
		{
			free(reply_with); 
			return PAM_CONV_ERR; 
		}
	} 

	*response = reply_with; 
	return PAM_SUCCESS; 
}

/** PAM Conversation for changing a users password */
#ifndef SOLARIS
int change_conv(int num_msg,const struct pam_message **msg, struct pam_response **response, void *appdata_ptr)
#else
int change_conv(int num_msg, struct pam_message **msg, struct pam_response **response, void *appdata_ptr)
#endif
{
	struct pam_response *reply_with = NULL; 
	int num_replies; 
	struct auth_struct *user_data;                  
		user_data = (struct auth_struct *) appdata_ptr; 

	if( num_msg <= 0 )
		return PAM_CONV_ERR;

	reply_with = (struct pam_response *)calloc(num_msg, sizeof(struct pam_response)); 

	if( reply_with == NULL )
		return PAM_SYSTEM_ERR;

	for( num_replies = 0; num_replies < num_msg; num_replies++ )
	{
		if( msg[num_replies]->msg_style == PAM_PROMPT_ECHO_OFF )
		{
			reply_with[num_replies].resp_retcode = PAM_SUCCESS; 
			reply_with[num_replies].resp = strdup(user_data->password); 
		}
		else if( msg[num_replies]->msg_style == PAM_PROMPT_ECHO_ON )
		{
			reply_with[num_replies].resp_retcode = PAM_SUCCESS; 
			reply_with[num_replies].resp = strdup(user_data->username); 
		}
		else
		{
			free(reply_with); 
			return PAM_CONV_ERR; 
		}
	} 

	*response = reply_with; 
	return PAM_SUCCESS; 
}
