#include "pgina_pam_misc.h"

void exit_error(int priority,char *message)
{
	// syslog the message
	syslog(priority,message);

	if(priority == LOG_ERR)
		exit(-1);
}


int become_daemon(void)
{
	//#ifndef DEBUG
#ifdef SOLARIS

	//JK: logically cosmetic change
	if (fork()==0)
	{
		setsid();
		if (fork()==0)
		{
			setpgrp();
			chdir("/");
			umask(0);
			fclose(stdin);
			fclose(stderr);
			fclose(stdout);
			return 0;
		}
	}
	_exit(0);

	return -1;

#if 0
	switch(fork())
	{
	case -1: /* fail */
		return -1;

	case 0:
		setsid();
		switch(fork())
		{
		case 0:
			setpgrp();
			chdir("/");
			umask(0);
			fclose(stdin);
			fclose(stderr);
			fclose(stdout);
			return 0;
		default:
			_exit(0);
		}
	default:
		_exit(0);
	}
#endif

#else
	chdir("/");
	umask(0);
	return daemon(0,0);
#endif

	/*#else
		chdir("/");
		umask(0);
		fclose(stdin);
		fclose(stdout);
		fclose(stderr);
		return 0;
	#endif*/
}

void debug_out(char *string, ...)
{

#ifdef DEBUG
	va_list argList;
	char buffer[30000];
	char *to_print = NULL;
	//	char current_time[256];
	//	time_t *time_struct;

	// Convert the va list
	va_start(argList,string);
	vsprintf(buffer,string,argList);
	va_end(argList);

	//  time(time_struct);
	//  strcpy(current_time,asctime(localtime(time_struct)));
	//    current_time = asctime(localtime(time_struct));
	//  current_time[strlen(current_time)-1] = '\0';

	// to_print = (char *) malloc(strlen(current_time) + strlen(buffer) + 25);
	to_print = (char *) malloc(strlen(buffer) + 25);

	if(to_print != NULL)
	{
		sprintf(to_print,"[%d]=%s",(int) getpid(),buffer);
		//sprintf(to_print,"%s",buffer);
		/*fprintf(trace_file,"%s\n",to_print);
		fflush(trace_file); // make sure it hits the file*/
		syslog(LOG_ERR,"%s",to_print);
		free(to_print);
		to_print = NULL;
	}
#endif
}
