/*
pGina PAM Server - A PAM-Aware Unix Daemon for pGina
Copyright (C) 2003 Nathan Yocom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: nate.yocom@xpasystems.com
Web: http://pgina.xpasystems.com
Snail Mail:
  Nathan Yocom 
  9 Evergreen Farms Rd.
  Scarborough, ME 04074
  Phone: 207-450-4948
*/
/*
	$Log: pgina_pam_server.h,v $
	Revision 1.2  2003/09/12 12:37:00  nyocom
	updated version to 1.1.3
	
	Revision 1.1  2003/08/06 04:58:36  nyocom
	Initial Import
	
	Revision 1.22  2003/06/11 16:57:43  nyocom
	Added PAM_AUTHTOK_EXPIRED and PAM_NEW_AUTHTOK_REQD notification
	
	Revision 1.21  2003/06/10 20:34:51  nyocom
	Added passing of hostname to pam
	Added check for expired authtok
	
	Revision 1.20  2003/06/01 12:25:12  nyocom
	Changed forking model to a post-fork (1:1 per connection)
	
	Revision 1.19  2003/05/16 01:52:18  jkim
	-with-authasst-group option added
	header dependency problem in compilation fixed in pgina_pam_misc.h
	importing authasst.groups config file
	
	Revision 1.18  2003/05/07 21:49:16  jkim
	Reorganized some header dependencies
	Moved some misc function to pgina_pam_misc.c
	Changed syslog to debug_out in authasst code
	Reformatted usage info to fit in 80 cols.
	
	Revision 1.17  2003/05/04 03:30:53  xpasys
	
	Bugfix for -strip-suffixes code.
	
	Revision 1.16  2003/05/01 17:23:10  xpasys
	Changed version to 1.0.0
	
	Revision 1.15  2003/05/01 03:47:49  xpasys
	fixed protocol problem with verify
	
	Revision 1.14  2003/05/01 02:40:27  xpasys
	Changed authasst to work with IP/FQDN/hostname.
	Imported source of Jiho's client into CVS
	
	Revision 1.13  2003/04/29 16:11:46  xpasys
	
	added authasst code
	changed argument parsing
	move some of main() to parent_loop()
	added prefork num option
	initial commit of authasst.c authasst.h linkedlist.c linkedlist.h.
	initial commit of authasst.conf files
	initial commit of Jiho's client test code.
	
	Revision 1.12  2003/04/28 18:51:52  xpasys
	Revised to version 0.9.9
	Changed autoconf to remove check for pthread
	
	Revision 1.11  2003/04/28 18:50:38  xpasys
	Drastic changes in move to fork model
	Prepared for adding auth_asst code
	Memory management enhancements
	
	Revision 1.10  2003/04/16 05:38:56  xpasys
	Added -pthread and -D_REENTRANT to CFLAGS
	Added debug_out code (enabled with ./configure --enable-debug)
	Fixed potential memory issues with call to do_authenticate
	Better malloc/free handling
	Actually responds with an error to a bad password change request now
	
	Revision 1.9  2003/04/11 05:24:07  xpasys
	Ready for 0.9.8b
	Better threading and mutexing
	Debug stats
	
	Revision 1.8  2003/04/11 04:50:26  xpasys
	Refitted mutexing to allow for better performance, possible solve
	deadlock issues
	Added debug trace info
	
	Revision 1.7  2003/04/07 17:18:26  xpasys
	Changed line endings to Unix
	Added code to be a bit friendlier on bad arguments (thanks to Jiho Kim)
	
	Revision 1.6  2003/04/05 03:35:10  xpasys
	Fixed segfault error in arg passing.  Oy.. I hate off-by-ones ;)
	
	Revision 1.5  2003/04/05 03:18:22  xpasys
	Added catch for extraneous messages (i.e. message flood) attack.
	
	Revision 1.4  2003/04/04 08:08:13  xpasys
	Pulled EGADs from autconf
	0.9.8 Ready for release
	
	Revision 1.3  2003/04/04 07:58:00  xpasys
	Made read_string() non_blocking, times out after some time
	Added -l for login service name
	Added -a for passwd service name
	Added -r for number of retries
	Added -s for sleep time (usecs)
	General security and stability improvements
	
	Revision 1.2  2003/04/03 04:42:45  xpasys
	Added better memory handling
	Added pthread_exit() instead of null returns
	Removed egads dependancy
	
	Revision 1.1.1.1  2003/03/22 06:02:20  xpasys
	Imported sources
	
*/


#ifndef PGINA_PAM_SERVER
#define PGINA_PAM_SERVER

//#include "config.h" // Config from autoconf
// Standard includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h> // for memset


#include <signal.h>
#include <time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <netdb.h>
#include <ctype.h>
#include <arpa/inet.h>


// SSL Includes
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/rand.h>

// PAM Includes
#include <security/pam_appl.h>

// Account information includes
#include <pwd.h>
#include <grp.h>

// Syslog
#include <syslog.h>

// Threads
#include <pthread.h>

//pgina_pam
#include "ssl_stuff.h"
#include "pgina_pam_misc.h"


#define SUCCESS "SUCC"
#define EXPIRED "EXP"
#define LOCKEDOUT "LKD"
#define ERROR "ERR"
#define NOT_SUPPORTED "NSUP"
#define AUTH_ACTION "AUTH"
#define VERIFY "VRFY"
#define CHANGE_PASS "CHPS"
#define GET_GROUP "GGRP"
#define DONE '!'
#define VERSION "pGina PAM Daemon - Version 1.1.3\nReleased under the GPL by XPA Systems\nhttp://www.xpasystems.com\nBy Nathan Yocom, Jiho Kim\n"
#define MAX_USERNAME_LENGTH 1024

//Global Variables
unsigned long sleep_time;
int num_retries;
char *login_service;
char *password_service;
char *port;
char *certfile;
int num_pre_fork;
int with_authasst;
int with_authasst_group;
SSL_CTX *ctx;


//process logic
void * server_loop(void *);
//void parent_loop(SSL_CTX *, BIO *);
void parent_loop(int);
//void child_loop(SSL_CTX *, BIO *);
void child_loop(int);


// PAM Conversation functions
#ifndef SOLARIS
int auth_conv(int, const struct pam_message **, struct pam_response **, void *);
int change_conv(int, const struct pam_message **, struct pam_response **, void *);
#else
int auth_conv(int, struct pam_message **, struct pam_response **, void *);
int change_conv(int, struct pam_message **, struct pam_response **, void *);
#endif

// Misc functions
int arg_parse(int, char**);



#endif
