/*
 * Decompiled with CFR 0.152.
 */
package com.bitzi.util;

import com.bitzi.util.Tiger;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import phex.utils.Logger;

public class TigerTree
extends MessageDigest {
    private static final int BLOCKSIZE = 1024;
    private static final int HASHSIZE = 24;
    private static final boolean USE_CRYPTIX;
    private final byte[] buffer = new byte[1024];
    private int bufferOffset = 0;
    private long byteCount = 0L;
    private MessageDigest tiger;
    private List nodes = new ArrayList();

    public TigerTree() {
        super("tigertree");
        if (USE_CRYPTIX) {
            try {
                this.tiger = MessageDigest.getInstance("Tiger", "CryptixCrypto");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.tiger = new Tiger();
            }
            catch (NoSuchProviderException noSuchProviderException) {
                this.tiger = new Tiger();
            }
        } else {
            this.tiger = new Tiger();
        }
    }

    protected int engineGetDigestLength() {
        return 24;
    }

    protected void engineUpdate(byte by) {
        ++this.byteCount;
        this.buffer[this.bufferOffset++] = by;
        if (this.bufferOffset == 1024) {
            this.blockUpdate();
            this.bufferOffset = 0;
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        int n3;
        this.byteCount += (long)n2;
        while (n2 >= (n3 = 1024 - this.bufferOffset)) {
            System.arraycopy(byArray, n, this.buffer, this.bufferOffset, n3);
            this.bufferOffset += n3;
            this.blockUpdate();
            n2 -= n3;
            n += n3;
            this.bufferOffset = 0;
        }
        System.arraycopy(byArray, n, this.buffer, this.bufferOffset, n2);
        this.bufferOffset += n2;
    }

    protected byte[] engineDigest() {
        byte[] byArray = new byte[24];
        try {
            this.engineDigest(byArray, 0, 24);
        }
        catch (DigestException digestException) {
            return null;
        }
        return byArray;
    }

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < 24) {
            throw new DigestException();
        }
        this.blockUpdate();
        while (this.nodes.size() > 1) {
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            Iterator iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                byte[] byArray2 = (byte[])iterator.next();
                if (iterator.hasNext()) {
                    byte[] byArray3 = (byte[])iterator.next();
                    this.tiger.reset();
                    this.tiger.update((byte)1);
                    this.tiger.update(byArray2, 0, byArray2.length);
                    this.tiger.update(byArray3, 0, byArray3.length);
                    arrayList.add(this.tiger.digest());
                    continue;
                }
                arrayList.add(byArray2);
            }
            this.nodes = arrayList;
        }
        System.arraycopy(this.nodes.get(0), 0, byArray, n, 24);
        this.engineReset();
        return 24;
    }

    protected void engineReset() {
        this.bufferOffset = 0;
        this.byteCount = 0L;
        this.nodes = new ArrayList();
        this.tiger.reset();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void blockUpdate() {
        this.tiger.reset();
        this.tiger.update((byte)0);
        this.tiger.update(this.buffer, 0, this.bufferOffset);
        if (this.bufferOffset == 0 & this.nodes.size() > 0) {
            return;
        }
        this.nodes.add(this.tiger.digest());
    }

    static {
        boolean bl = USE_CRYPTIX = SystemUtils.isJavaVersionAtLeast(140) && SystemUtils.IS_OS_MAC_OSX && SystemUtils.OS_VERSION.startsWith("10.2");
        if (USE_CRYPTIX) {
            try {
                Class<?> clazz = Class.forName("cryptix.jce.provider.CryptixCrypto");
                Object obj = clazz.newInstance();
                Security.addProvider((Provider)obj);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.logError(classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                Logger.logError(instantiationException);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                Logger.logError(exceptionInInitializerError);
            }
            catch (SecurityException securityException) {
                Logger.logError(securityException);
            }
            catch (ClassCastException classCastException) {
                Logger.logError(classCastException);
            }
        }
    }
}

