/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;

class FunctorUtils {
    private FunctorUtils() {
    }

    static Predicate[] copy(Predicate[] predicateArray) {
        if (predicateArray == null) {
            return null;
        }
        return (Predicate[])predicateArray.clone();
    }

    static void validate(Predicate[] predicateArray) {
        if (predicateArray == null) {
            throw new IllegalArgumentException("The predicate array must not be null");
        }
        for (int i = 0; i < predicateArray.length; ++i) {
            if (predicateArray[i] != null) continue;
            throw new IllegalArgumentException("The predicate array must not contain a null predicate, index " + i + " was null");
        }
    }

    static void validateMin2(Predicate[] predicateArray) {
        if (predicateArray == null) {
            throw new IllegalArgumentException("The predicate array must not be null");
        }
        if (predicateArray.length < 2) {
            throw new IllegalArgumentException("At least 2 predicates must be specified in the predicate array, size was " + predicateArray.length);
        }
        for (int i = 0; i < predicateArray.length; ++i) {
            if (predicateArray[i] != null) continue;
            throw new IllegalArgumentException("The predicate array must not contain a null predicate, index " + i + " was null");
        }
    }

    static Predicate[] validate(Collection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("The predicate collection must not be null");
        }
        if (collection.size() < 2) {
            throw new IllegalArgumentException("At least 2 predicates must be specified in the predicate collection, size was " + collection.size());
        }
        Predicate[] predicateArray = new Predicate[collection.size()];
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            predicateArray[n] = (Predicate)iterator.next();
            if (predicateArray[n] == null) {
                throw new IllegalArgumentException("The predicate collection must not contain a null predicate, index " + n + " was null");
            }
            ++n;
        }
        return predicateArray;
    }

    static Closure[] copy(Closure[] closureArray) {
        if (closureArray == null) {
            return null;
        }
        return (Closure[])closureArray.clone();
    }

    static void validate(Closure[] closureArray) {
        if (closureArray == null) {
            throw new IllegalArgumentException("The closure array must not be null");
        }
        for (int i = 0; i < closureArray.length; ++i) {
            if (closureArray[i] != null) continue;
            throw new IllegalArgumentException("The closure array must not contain a null closure, index " + i + " was null");
        }
    }

    static Transformer[] copy(Transformer[] transformerArray) {
        if (transformerArray == null) {
            return null;
        }
        return (Transformer[])transformerArray.clone();
    }

    static void validate(Transformer[] transformerArray) {
        if (transformerArray == null) {
            throw new IllegalArgumentException("The transformer array must not be null");
        }
        for (int i = 0; i < transformerArray.length; ++i) {
            if (transformerArray[i] != null) continue;
            throw new IllegalArgumentException("The transformer array must not contain a null transformer, index " + i + " was null");
        }
    }
}

