/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.FunctorUtils;

public final class NonePredicate
implements Predicate,
Serializable {
    static final long serialVersionUID = 2007613066565892961L;
    private final Predicate[] iPredicates;

    public static Predicate getInstance(Predicate[] predicateArray) {
        FunctorUtils.validateMin2(predicateArray);
        predicateArray = FunctorUtils.copy(predicateArray);
        return new NonePredicate(predicateArray);
    }

    public static Predicate getInstance(Collection collection) {
        Predicate[] predicateArray = FunctorUtils.validate(collection);
        return new NonePredicate(predicateArray);
    }

    public NonePredicate(Predicate[] predicateArray) {
        this.iPredicates = predicateArray;
    }

    public boolean evaluate(Object object) {
        for (int i = 0; i < this.iPredicates.length; ++i) {
            if (!this.iPredicates[i].evaluate(object)) continue;
            return false;
        }
        return true;
    }
}

