/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class HashCodeBuilder {
    private final int iConstant;
    private int iTotal = 0;

    public HashCodeBuilder() {
        this.iConstant = 37;
        this.iTotal = 17;
    }

    public HashCodeBuilder(int n, int n2) {
        if (n == 0) {
            throw new IllegalArgumentException("HashCodeBuilder requires a non zero initial value");
        }
        if (n % 2 == 0) {
            throw new IllegalArgumentException("HashCodeBuilder requires an odd initial value");
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("HashCodeBuilder requires a non zero multiplier");
        }
        if (n2 % 2 == 0) {
            throw new IllegalArgumentException("HashCodeBuilder requires an odd multiplier");
        }
        this.iConstant = n2;
        this.iTotal = n;
    }

    public static int reflectionHashCode(Object object) {
        return HashCodeBuilder.reflectionHashCode(17, 37, object, false, null);
    }

    public static int reflectionHashCode(Object object, boolean bl) {
        return HashCodeBuilder.reflectionHashCode(17, 37, object, bl, null);
    }

    public static int reflectionHashCode(int n, int n2, Object object) {
        return HashCodeBuilder.reflectionHashCode(n, n2, object, false, null);
    }

    public static int reflectionHashCode(int n, int n2, Object object, boolean bl) {
        return HashCodeBuilder.reflectionHashCode(n, n2, object, bl, null);
    }

    public static int reflectionHashCode(int n, int n2, Object object, boolean bl, Class clazz) {
        Class<?> clazz2;
        if (object == null) {
            throw new IllegalArgumentException("The object to build a hash code for must not be null");
        }
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(n, n2);
        HashCodeBuilder.reflectionAppend(object, clazz2, hashCodeBuilder, bl);
        for (clazz2 = object.getClass(); clazz2.getSuperclass() != null && clazz2 != clazz; clazz2 = clazz2.getSuperclass()) {
            HashCodeBuilder.reflectionAppend(object, clazz2, hashCodeBuilder, bl);
        }
        return hashCodeBuilder.toHashCode();
    }

    private static void reflectionAppend(Object object, Class clazz, HashCodeBuilder hashCodeBuilder, boolean bl) {
        AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(accessibleObjectArray, true);
        for (int i = 0; i < accessibleObjectArray.length; ++i) {
            AccessibleObject accessibleObject = accessibleObjectArray[i];
            if (((Field)accessibleObject).getName().indexOf(36) != -1 || !bl && Modifier.isTransient(((Field)accessibleObject).getModifiers()) || Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            try {
                hashCodeBuilder.append(((Field)accessibleObject).get(object));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError("Unexpected IllegalAccessException");
            }
        }
    }

    public HashCodeBuilder appendSuper(int n) {
        this.iTotal = this.iTotal * this.iConstant + n;
        return this;
    }

    public HashCodeBuilder append(Object object) {
        if (object == null) {
            this.iTotal *= this.iConstant;
        } else if (!object.getClass().isArray()) {
            this.iTotal = this.iTotal * this.iConstant + object.hashCode();
        } else if (object instanceof long[]) {
            this.append((long[])object);
        } else if (object instanceof int[]) {
            this.append((int[])object);
        } else if (object instanceof short[]) {
            this.append((short[])object);
        } else if (object instanceof char[]) {
            this.append((char[])object);
        } else if (object instanceof byte[]) {
            this.append((byte[])object);
        } else if (object instanceof double[]) {
            this.append((double[])object);
        } else if (object instanceof float[]) {
            this.append((float[])object);
        } else if (object instanceof boolean[]) {
            this.append((boolean[])object);
        } else {
            this.append((Object[])object);
        }
        return this;
    }

    public HashCodeBuilder append(long l) {
        this.iTotal = this.iTotal * this.iConstant + (int)(l ^ l >> 32);
        return this;
    }

    public HashCodeBuilder append(int n) {
        this.iTotal = this.iTotal * this.iConstant + n;
        return this;
    }

    public HashCodeBuilder append(short s) {
        this.iTotal = this.iTotal * this.iConstant + s;
        return this;
    }

    public HashCodeBuilder append(char c) {
        this.iTotal = this.iTotal * this.iConstant + c;
        return this;
    }

    public HashCodeBuilder append(byte by) {
        this.iTotal = this.iTotal * this.iConstant + by;
        return this;
    }

    public HashCodeBuilder append(double d) {
        return this.append(Double.doubleToLongBits(d));
    }

    public HashCodeBuilder append(float f) {
        this.iTotal = this.iTotal * this.iConstant + Float.floatToIntBits(f);
        return this;
    }

    public HashCodeBuilder append(boolean bl) {
        this.iTotal = this.iTotal * this.iConstant + (bl ? 0 : 1);
        return this;
    }

    public HashCodeBuilder append(Object[] objectArray) {
        if (objectArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                this.append(objectArray[i]);
            }
        }
        return this;
    }

    public HashCodeBuilder append(long[] lArray) {
        if (lArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (int i = 0; i < lArray.length; ++i) {
                this.append(lArray[i]);
            }
        }
        return this;
    }

    public HashCodeBuilder append(int[] nArray) {
        if (nArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                this.append(nArray[i]);
            }
        }
        return this;
    }

    public HashCodeBuilder append(short[] sArray) {
        if (sArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (int i = 0; i < sArray.length; ++i) {
                this.append(sArray[i]);
            }
        }
        return this;
    }

    public HashCodeBuilder append(char[] cArray) {
        if (cArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (int i = 0; i < cArray.length; ++i) {
                this.append(cArray[i]);
            }
        }
        return this;
    }

    public HashCodeBuilder append(byte[] byArray) {
        if (byArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (int i = 0; i < byArray.length; ++i) {
                this.append(byArray[i]);
            }
        }
        return this;
    }

    public HashCodeBuilder append(double[] dArray) {
        if (dArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                this.append(dArray[i]);
            }
        }
        return this;
    }

    public HashCodeBuilder append(float[] fArray) {
        if (fArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (int i = 0; i < fArray.length; ++i) {
                this.append(fArray[i]);
            }
        }
        return this;
    }

    public HashCodeBuilder append(boolean[] blArray) {
        if (blArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (int i = 0; i < blArray.length; ++i) {
                this.append(blArray[i]);
            }
        }
        return this;
    }

    public int toHashCode() {
        return this.iTotal;
    }
}

