/*
 * Decompiled with CFR 0.152.
 */
package phex.chat;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import phex.chat.ChatManager;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.bandwidth.BandwidthManager;
import phex.host.HostAddress;
import phex.net.connection.OIOSocketFactory;
import phex.utils.BandwidthInputStream;
import phex.utils.BandwidthOutputStream;
import phex.utils.GnutellaInputStream;
import phex.utils.IOUtil;
import phex.utils.Logger;

public class ChatEngine {
    private boolean isOutgoingConnection;
    private Socket socket;
    private GnutellaInputStream chatReader;
    private BufferedWriter chatWriter;
    private String chatNick;
    private HostAddress hostAddress;

    public ChatEngine(Socket socket, GnutellaInputStream gnutellaInputStream, HostAddress hostAddress) throws IOException {
        this.socket = socket;
        this.hostAddress = hostAddress;
        this.chatReader = gnutellaInputStream;
        BandwidthOutputStream bandwidthOutputStream = new BandwidthOutputStream(this.socket.getOutputStream(), BandwidthManager.getInstance().getNetworkBandwidthController());
        this.chatWriter = new BufferedWriter(new OutputStreamWriter(bandwidthOutputStream));
        this.chatNick = this.hostAddress.getHostName();
        this.finalizeHandshake();
        this.isOutgoingConnection = false;
    }

    public ChatEngine(HostAddress hostAddress) {
        this.hostAddress = hostAddress;
        this.isOutgoingConnection = true;
        this.chatNick = this.hostAddress.getHostName();
    }

    public void startChat() {
        ChatReadWorker chatReadWorker = new ChatReadWorker();
        ThreadPool.getInstance().addJob(chatReadWorker, "ChatReadWorker-" + Integer.toHexString(chatReadWorker.hashCode()));
    }

    public void stopChat() {
        if (this.chatReader != null) {
            this.chatReader.close();
            this.chatReader = null;
        }
        IOUtil.closeQuietly(this.chatWriter);
        this.chatWriter = null;
        IOUtil.closeQuietly(this.socket);
        this.socket = null;
        ChatManager.getInstance().fireChatConnectionFailed(this);
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    public String getChatNick() {
        return this.chatNick;
    }

    public void sendChatMessage(String string) {
        if (this.chatWriter == null) {
            ChatManager.getInstance().fireChatConnectionFailed(this);
        }
        try {
            this.chatWriter.write(string + "\n");
            this.chatWriter.flush();
        }
        catch (IOException iOException) {
            Logger.logWarning((short)16, iOException);
            this.stopChat();
        }
    }

    private void finalizeHandshake() throws IOException {
        String string;
        this.socket.setSoTimeout(ServiceManager.sCfg.socketConnectTimeout);
        do {
            string = this.chatReader.readLine();
            Logger.logMessage(Logger.FINE, (short)16, "Read Chat header: " + string);
            if (string == null) {
                throw new IOException("No handshake response from chat partner.");
            }
            String string2 = string.toUpperCase();
            if (!string2.startsWith("X-NICKNAME:")) continue;
            this.chatNick = string.substring(11).trim();
            Logger.logMessage(Logger.FINE, (short)16, "Chat Nick: " + this.chatNick);
        } while (string.length() > 0);
        Logger.logMessage(Logger.FINE, (short)16, "Sending: CHAT/0.1 200 OK");
        this.chatWriter.write("CHAT/0.1 200 OK\r\nUser-Agent: " + Environment.getPhexVendor() + "\r\n" + "\r\n");
        this.chatWriter.flush();
        do {
            string = this.chatReader.readLine();
            Logger.logMessage(Logger.FINE, (short)16, "Read Chat response: " + string);
            if (string != null) continue;
            throw new IOException("No handshake response from chat partner.");
        } while (string.length() > 0);
        this.socket.setSoTimeout(0);
    }

    private void connectOutgoingChat() throws IOException {
        String string;
        Logger.logMessage(Logger.FINE, (short)16, "Connect outgoing to: " + this.hostAddress.getFullHostName());
        this.socket = OIOSocketFactory.connect(this.hostAddress, ServiceManager.sCfg.mNetConnectionTimeout);
        BandwidthOutputStream bandwidthOutputStream = new BandwidthOutputStream(this.socket.getOutputStream(), BandwidthManager.getInstance().getNetworkBandwidthController());
        this.chatWriter = new BufferedWriter(new OutputStreamWriter(bandwidthOutputStream));
        String string2 = "CHAT CONNECT/0.1\r\nUser-Agent: " + Environment.getPhexVendor() + "\r\n" + "\r\n";
        Logger.logMessage(Logger.FINE, (short)16, "Sending: " + string2);
        this.chatWriter.write(string2);
        this.chatWriter.flush();
        BandwidthInputStream bandwidthInputStream = new BandwidthInputStream(this.socket.getInputStream(), BandwidthManager.getInstance().getNetworkBandwidthController());
        this.chatReader = new GnutellaInputStream(bandwidthInputStream);
        do {
            string = this.chatReader.readLine();
            Logger.logMessage(Logger.FINE, (short)16, "Read Chat header: " + string);
            if (string == null) {
                throw new IOException("No handshake response from chat partner.");
            }
            String string3 = string.toUpperCase();
            if (!string3.startsWith("X-NICKNAME:")) continue;
            this.chatNick = string.substring(11).trim();
        } while (string.length() > 0);
        this.chatWriter.write("CHAT/0.1 200 OK\r\nUser-Agent: " + Environment.getPhexVendor() + "\r\n\r\n");
        this.chatWriter.flush();
        this.socket.setSoTimeout(0);
    }

    private class ChatReadWorker
    implements Runnable {
        private ChatReadWorker() {
        }

        public void run() {
            if (ChatEngine.this.isOutgoingConnection) {
                try {
                    ChatEngine.this.connectOutgoingChat();
                }
                catch (IOException iOException) {
                    ChatEngine.this.stopChat();
                    return;
                }
            }
            ChatManager chatManager = ChatManager.getInstance();
            try {
                while (true) {
                    String string;
                    if ((string = ChatEngine.this.chatReader.readLine()) == null) {
                        throw new IOException("Remote host diconnected chat.");
                    }
                    if (string.length() == 0) continue;
                    Logger.logMessage(Logger.FINER, (short)16, "Reading chat message: " + string);
                    chatManager.fireChatMessageReceived(ChatEngine.this, string);
                }
            }
            catch (IOException iOException) {
                Logger.logMessage(Logger.FINER, (short)16, iOException);
                ChatEngine.this.stopChat();
                return;
            }
        }
    }
}

