/*
 * Decompiled with CFR 0.152.
 */
package phex.chat;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import phex.chat.ChatEngine;
import phex.common.Manager;
import phex.common.ServiceManager;
import phex.event.AsynchronousDispatcher;
import phex.event.ChatListener;
import phex.host.HostAddress;
import phex.utils.GnutellaInputStream;
import phex.utils.Logger;

public class ChatManager
implements Manager {
    private static ChatManager instance;
    private ArrayList listenerList = new ArrayList(1);

    private ChatManager() {
    }

    public static ChatManager getInstance() {
        if (instance == null) {
            instance = new ChatManager();
        }
        return instance;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
    }

    public void openChat(HostAddress hostAddress) {
        ChatEngine chatEngine = new ChatEngine(hostAddress);
        chatEngine.startChat();
        this.fireChatConnectionOpened(chatEngine);
    }

    public void acceptChat(Socket socket, GnutellaInputStream gnutellaInputStream, HostAddress hostAddress) {
        if (!ServiceManager.sCfg.isChatEnabled) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try {
            ChatEngine chatEngine = new ChatEngine(socket, gnutellaInputStream, hostAddress);
            chatEngine.startChat();
            this.fireChatConnectionOpened(chatEngine);
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINE, (short)16, iOException);
            try {
                socket.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return;
        }
    }

    public void addChatListener(ChatListener chatListener) {
        this.listenerList.add(chatListener);
    }

    public void removeChatListener(ChatListener chatListener) {
        this.listenerList.remove(chatListener);
    }

    public void fireChatConnectionOpened(final ChatEngine chatEngine) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = ChatManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    ChatListener chatListener = (ChatListener)objectArray[i];
                    chatListener.chatConnectionOpened(chatEngine);
                }
            }
        });
    }

    public void fireChatConnectionFailed(final ChatEngine chatEngine) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = ChatManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    ChatListener chatListener = (ChatListener)objectArray[i];
                    chatListener.chatConnectionFailed(chatEngine);
                }
            }
        });
    }

    public void fireChatMessageReceived(final ChatEngine chatEngine, final String string) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = ChatManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    ChatListener chatListener = (ChatListener)objectArray[i];
                    chatListener.chatMessageReceived(chatEngine, string);
                }
            }
        });
    }
}

