/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import phex.common.URN;
import phex.host.HostAddress;
import phex.host.MalformedHostAddressException;
import phex.security.PhexSecurityManager;
import phex.utils.Logger;

public class AlternateLocation {
    public static final Short DEFAULT_HOST_RATING = new Short(6);
    private HostAddress hostAddress;
    private URN urn;

    public AlternateLocation(HostAddress hostAddress, URN uRN) {
        this.hostAddress = hostAddress;
        this.urn = uRN;
    }

    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    public URN getURN() {
        return this.urn;
    }

    public String getHTTPString() {
        StringBuffer stringBuffer = new StringBuffer(this.hostAddress.getHostName());
        int n = this.hostAddress.getPort();
        if (n != 6346) {
            stringBuffer.append(':');
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AlternateLocation)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        AlternateLocation alternateLocation = (AlternateLocation)object;
        return this.hostAddress.equals(alternateLocation.hostAddress) && this.urn.equals(alternateLocation.urn);
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + (this.hostAddress != null ? this.hostAddress.hashCode() : 0);
        n = 31 * n + (this.urn != null ? this.urn.hashCode() : 0);
        return n;
    }

    public static AlternateLocation parseCompactIpAltLoc(String string, URN uRN) {
        HostAddress hostAddress;
        try {
            hostAddress = HostAddress.parseAndValidateAddress(string, false);
        }
        catch (MalformedHostAddressException malformedHostAddressException) {
            Logger.logMessage(Logger.FINE, (short)2, "Malformed alt-location URL: " + malformedHostAddressException.getMessage());
            return null;
        }
        AlternateLocation alternateLocation = new AlternateLocation(hostAddress, uRN);
        return alternateLocation;
    }

    public static AlternateLocation parseUriResAltLoc(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f\"");
        String string2 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        try {
            URL uRL = new URL(string2);
            String string3 = uRL.getProtocol();
            if (!"http".equals(string3)) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Not a http URL): " + string2);
                return null;
            }
            String string4 = uRL.getHost();
            int n = uRL.getPort();
            if (n == -1) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid legacy alt-loc without specified port.");
                return null;
            }
            if (!HostAddress.isPortInRange(n)) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Port out of range): " + string2);
                return null;
            }
            HostAddress hostAddress = new HostAddress(string4, n);
            byte by = PhexSecurityManager.getInstance().controlHostIPAccess(hostAddress.getHostIP());
            switch (by) {
                case 2: 
                case 3: {
                    Logger.logMessage(Logger.FINE, (short)2, "Alt-Location host denied: " + string2);
                    return null;
                }
            }
            if (!hostAddress.isValidIP()) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Invalid IP used): " + string2);
                return null;
            }
            if (hostAddress.isPrivateIP()) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Private IP used): " + string2);
                return null;
            }
            URN uRN = URN.parseURNFromUriRes(uRL.getFile());
            if (uRN == null) {
                Logger.logMessage(Logger.FINE, (short)2, "Alt-location path without URN: " + string);
                return null;
            }
            AlternateLocation alternateLocation = new AlternateLocation(hostAddress, uRN);
            return alternateLocation;
        }
        catch (UnknownHostException unknownHostException) {
            Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (UnknownHost: " + unknownHostException.getMessage() + " ): " + string2);
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Malformed: " + malformedURLException.getMessage() + " ): " + string2);
            return null;
        }
    }
}

