/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections.SequencedHashMap;
import phex.common.AlternateLocation;
import phex.common.URN;
import phex.host.HostAddress;
import phex.http.HTTPHeader;
import phex.utils.Logger;
import phex.xml.ObjectFactory;
import phex.xml.XJBAlternateLocation;

public class AlternateLocationContainer {
    public static final int MAX_ALT_LOC_COUNT = 100;
    private static final Object PRESENT = new Object();
    private URN urn;
    private SequencedHashMap altLocationMap;

    public AlternateLocationContainer(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("URN must be provided");
        }
        this.urn = uRN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainer(AlternateLocationContainer alternateLocationContainer) {
        if (alternateLocationContainer.urn == null || !alternateLocationContainer.urn.equals(this.urn)) {
            throw new IllegalArgumentException("Trying to add container with not matching urns");
        }
        if (alternateLocationContainer.altLocationMap == null) {
            return;
        }
        this.initMap();
        SequencedHashMap sequencedHashMap = alternateLocationContainer.altLocationMap;
        synchronized (sequencedHashMap) {
            Iterator iterator = alternateLocationContainer.altLocationMap.keySet().iterator();
            while (iterator.hasNext()) {
                AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                this.addAlternateLocation(alternateLocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlternateLocation(AlternateLocation alternateLocation) {
        URN uRN = alternateLocation.getURN();
        if (uRN == null || !uRN.equals(this.urn)) {
            Logger.logMessage(Logger.WARNING, (short)2, "Cant add alt-location with not matching URN to container ");
            return;
        }
        this.initMap();
        SequencedHashMap sequencedHashMap = this.altLocationMap;
        synchronized (sequencedHashMap) {
            this.altLocationMap.put(alternateLocation, PRESENT);
            if (this.altLocationMap.size() > 100) {
                Object object = this.altLocationMap.getFirstKey();
                this.altLocationMap.remove(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlternateLocation(AlternateLocation alternateLocation) {
        URN uRN = alternateLocation.getURN();
        if (uRN == null || !uRN.equals(this.urn)) {
            Logger.logMessage(Logger.WARNING, (short)2, "Cant remove alt-location with not matching URN to container ");
            return;
        }
        this.initMap();
        SequencedHashMap sequencedHashMap = this.altLocationMap;
        synchronized (sequencedHashMap) {
            this.altLocationMap.remove(alternateLocation);
        }
    }

    public void addFromUriResHTTPHeaders(HTTPHeader[] hTTPHeaderArray) {
        List list = AlternateLocationContainer.parseUriResAltLocFromHTTPHeaders(hTTPHeaderArray);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addAlternateLocation((AlternateLocation)iterator.next());
        }
    }

    public void addFromCompactIpHTTPHeaders(HTTPHeader[] hTTPHeaderArray, URN uRN) {
        List list = AlternateLocationContainer.parseCompactIpAltLocFromHTTPHeaders(hTTPHeaderArray, uRN);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addAlternateLocation((AlternateLocation)iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPHeader getAltLocHTTPHeaderForAddress(String string, HostAddress hostAddress, Set set) {
        if (this.isEmpty()) {
            return null;
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.altLocationMap;
        synchronized (object) {
            Iterator iterator = this.altLocationMap.keySet().iterator();
            while (iterator.hasNext()) {
                AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                if (hostAddress.getHostName().equals(alternateLocation.getHostAddress().getHostName()) || set.contains(alternateLocation)) continue;
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(alternateLocation.getHTTPString());
                set.add(alternateLocation);
                if (++n != 10) continue;
                break;
            }
        }
        if (stringBuffer.length() > 0) {
            object = new HTTPHeader(string, stringBuffer.toString());
            return object;
        }
        return null;
    }

    public synchronized int getSize() {
        if (this.altLocationMap == null) {
            return 0;
        }
        return this.altLocationMap.size();
    }

    public synchronized boolean isEmpty() {
        if (this.altLocationMap == null) {
            return true;
        }
        return this.altLocationMap.isEmpty();
    }

    public synchronized void createXJBAlternateLocationList(List list) throws JAXBException {
        if (this.altLocationMap == null) {
            return;
        }
        Iterator iterator = this.altLocationMap.keySet().iterator();
        ObjectFactory objectFactory = new ObjectFactory();
        while (iterator.hasNext()) {
            AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
            XJBAlternateLocation xJBAlternateLocation = objectFactory.createXJBAlternateLocation();
            xJBAlternateLocation.setHostAddress(alternateLocation.getHostAddress().getFullHostName());
            xJBAlternateLocation.setURN(alternateLocation.getURN().getAsString());
            list.add(xJBAlternateLocation);
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Alt-Locations(SHA1: ");
        stringBuffer.append(this.urn.getAsString());
        stringBuffer.append(")=[ ");
        if (this.altLocationMap != null) {
            Iterator iterator = this.altLocationMap.keySet().iterator();
            while (iterator.hasNext()) {
                AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                stringBuffer.append(alternateLocation.toString());
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    private void initMap() {
        if (this.altLocationMap == null) {
            this.altLocationMap = new SequencedHashMap();
        }
    }

    public static List parseUriResAltLocFromHTTPHeaders(HTTPHeader[] hTTPHeaderArray) {
        if (hTTPHeaderArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<AlternateLocation> arrayList = new ArrayList<AlternateLocation>();
        for (int i = 0; i < hTTPHeaderArray.length; ++i) {
            HTTPHeader hTTPHeader = hTTPHeaderArray[i];
            StringTokenizer stringTokenizer = new StringTokenizer(hTTPHeader.getValue(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    String string = stringTokenizer.nextToken().trim();
                    AlternateLocation alternateLocation = AlternateLocation.parseUriResAltLoc(string);
                    if (alternateLocation == null) continue;
                    arrayList.add(alternateLocation);
                }
                catch (Exception exception) {
                    Logger.logError(exception);
                }
            }
        }
        return arrayList;
    }

    public static List parseCompactIpAltLocFromHTTPHeaders(HTTPHeader[] hTTPHeaderArray, URN uRN) {
        if (hTTPHeaderArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<AlternateLocation> arrayList = new ArrayList<AlternateLocation>();
        for (int i = 0; i < hTTPHeaderArray.length; ++i) {
            HTTPHeader hTTPHeader = hTTPHeaderArray[i];
            StringTokenizer stringTokenizer = new StringTokenizer(hTTPHeader.getValue(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    String string = stringTokenizer.nextToken().trim();
                    AlternateLocation alternateLocation = AlternateLocation.parseCompactIpAltLoc(string, uRN);
                    if (alternateLocation == null) continue;
                    arrayList.add(alternateLocation);
                }
                catch (Exception exception) {
                    Logger.logError(exception);
                }
            }
        }
        return arrayList;
    }
}

